/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.AStatus;
import com.sun.javatest.regtest.agent.ActionHelper;
import com.sun.javatest.regtest.agent.Alarm;
import com.sun.javatest.regtest.agent.CompileActionHelper;
import com.sun.javatest.regtest.agent.Flags;
import com.sun.javatest.regtest.agent.MainActionHelper;
import com.sun.javatest.regtest.agent.RegressionSecurityManager;
import com.sun.javatest.regtest.agent.SearchPath;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class AgentServer
implements ActionHelper.OutputHandler {
    public static final boolean traceServer = Flags.get("traceServer");
    public static final String ALLOW_SET_SECURITY_MANAGER = "-allowSetSecurityManager";
    public static final String ID = "-id";
    public static final String LOGFILE = "-logfile";
    public static final String HOST = "-host";
    public static final String PORT = "-port";
    public static final String TIMEOUTFACTOR = "-timeoutFactor";
    public static final byte DO_COMPILE = 1;
    public static final byte DO_MAIN = 2;
    public static final byte OUTPUT = 3;
    public static final byte STATUS = 4;
    public static final byte KEEPALIVE = 5;
    public static final byte CLOSE = 6;
    private float timeoutFactor = 1.0f;
    public static final SimpleDateFormat logDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private final KeepAlive keepAlive;
    private final DataInputStream in;
    private final DataOutputStream out;
    private final PrintStream traceOut = System.err;
    private final PrintWriter logWriter;
    private final int id;
    private final Map<ActionHelper.OutputHandler.OutputKind, Writer> writers = new EnumMap<ActionHelper.OutputHandler.OutputKind, Writer>(ActionHelper.OutputHandler.OutputKind.class);

    public static void main(String ... stringArray) {
        if (traceServer) {
            System.err.println("AgentServer.main");
        }
        try {
            new AgentServer(stringArray).run();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public AgentServer(String ... stringArray) throws IOException {
        Object object;
        if (traceServer) {
            this.traceOut.println("Agent.Server started");
        }
        boolean bl = false;
        InetAddress inetAddress = InetAddress.getByName("localhost");
        int n = 0;
        int n2 = -1;
        File file = null;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (((String)object).equals(ID)) {
                try {
                    n = Integer.parseInt(stringArray[++i]);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                continue;
            }
            if (((String)object).equals(LOGFILE)) {
                file = new File(stringArray[++i]);
                continue;
            }
            if (((String)object).equals(ALLOW_SET_SECURITY_MANAGER)) {
                bl = true;
                continue;
            }
            if (((String)object).equals(PORT) && i + 1 < stringArray.length) {
                n2 = Integer.valueOf(stringArray[++i]);
                continue;
            }
            if (((String)object).equals(HOST) && i + 1 < stringArray.length) {
                inetAddress = InetAddress.getByName(stringArray[++i]);
                continue;
            }
            if (((String)object).equals(TIMEOUTFACTOR) && i + 1 < stringArray.length) {
                this.timeoutFactor = Float.valueOf(stringArray[++i]).floatValue();
                continue;
            }
            throw new IllegalArgumentException((String)object);
        }
        this.id = n;
        PrintWriter printWriter = null;
        if (file != null) {
            try {
                printWriter = new PrintWriter(new FileWriter(file));
            }
            catch (IOException iOException) {
                this.traceOut.println("Cannot open log writer: " + iOException);
                printWriter = new PrintWriter(System.err){

                    @Override
                    public void close() {
                        this.flush();
                    }
                };
            }
        }
        this.logWriter = printWriter;
        this.log("Started");
        if (n2 > 0) {
            object = new Socket(inetAddress, n2);
            ((Socket)object).setSoTimeout((int)(120000.0f * this.timeoutFactor));
            this.in = new DataInputStream(new BufferedInputStream(((Socket)object).getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(((Socket)object).getOutputStream()));
            this.log("Listening on port " + n2);
        } else {
            this.in = new DataInputStream(new BufferedInputStream(System.in));
            this.out = new DataOutputStream(new BufferedOutputStream(System.out));
        }
        this.keepAlive = new KeepAlive(this.out, traceServer);
        RegressionSecurityManager.install();
        object = System.getSecurityManager();
        if (object instanceof RegressionSecurityManager) {
            RegressionSecurityManager regressionSecurityManager = (RegressionSecurityManager)object;
            regressionSecurityManager.setAllowPropertiesAccess(true);
            if (bl) {
                regressionSecurityManager.setAllowSetSecurityManager(true);
            }
            regressionSecurityManager.setAllowSetIO(true);
        }
    }

    public void run() throws IOException {
        this.log("Running");
        try {
            int n;
            while ((n = this.in.read()) != -1) {
                switch (n) {
                    case 1: {
                        this.doCompile();
                        break;
                    }
                    case 2: {
                        this.doMain();
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        return;
                    }
                    default: {
                        throw new Error("Agent.Server: unexpected op: " + n);
                    }
                }
                this.out.flush();
            }
        }
        finally {
            this.keepAlive.finished();
            this.log("Exiting");
            this.logWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompile() throws IOException {
        if (traceServer) {
            this.traceOut.println("Agent.Server.doCompile");
        }
        String string = this.in.readUTF();
        Map<String, String> map = AgentServer.readMap(this.in);
        List<String> list = AgentServer.readList(this.in);
        this.log(string + ": starting compilation");
        this.keepAlive.setEnabled(true);
        try {
            AStatus aStatus = CompileActionHelper.runCompile(string, map, list, 0, this);
            this.writeStatus(aStatus);
        }
        finally {
            this.keepAlive.setEnabled(false);
            this.log(string + ": finished compilation");
        }
        if (traceServer) {
            this.traceOut.println("Agent.Server.doCompile DONE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMain() throws IOException {
        if (traceServer) {
            this.traceOut.println("Agent.Server.doMain");
        }
        String string = this.in.readUTF();
        Map<String, String> map = AgentServer.readMap(this.in);
        Set<String> set = AgentServer.readSet(this.in);
        Set<String> set2 = AgentServer.readSet(this.in);
        Set<String> set3 = AgentServer.readSet(this.in);
        SearchPath searchPath = new SearchPath(this.in.readUTF());
        SearchPath searchPath2 = new SearchPath(this.in.readUTF());
        String string2 = this.in.readUTF();
        List<String> list = AgentServer.readList(this.in);
        if (traceServer) {
            this.traceOut.println("Agent.Server.doMain: " + string);
        }
        this.log(string + ": starting execution of " + string2);
        this.keepAlive.setEnabled(true);
        try {
            AStatus aStatus = new MainActionHelper(string).properties(map).addExports(set).addOpens(set2).addMods(set3).classpath(searchPath).modulepath(searchPath2).className(string2).classArgs(list).timeout(0).timeoutFactor(this.timeoutFactor).outputHandler(this).runClass();
            this.writeStatus(aStatus);
        }
        finally {
            this.keepAlive.setEnabled(false);
            this.log(string + ": finished execution of " + string2);
        }
        if (traceServer) {
            this.traceOut.println("Agent.Server.doMain DONE");
        }
    }

    static List<String> readList(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(dataInputStream.readUTF());
        }
        return arrayList;
    }

    static Set<String> readSet(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(n);
        for (int i = 0; i < n; ++i) {
            linkedHashSet.add(dataInputStream.readUTF());
        }
        return linkedHashSet;
    }

    static Map<String, String> readMap(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        HashMap<String, String> hashMap = new HashMap<String, String>(n, 1.0f);
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatus(AStatus aStatus) throws IOException {
        if (traceServer) {
            this.traceOut.println("Agent.Server.writeStatus: " + aStatus);
        }
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.writeByte(4);
            this.out.writeByte(aStatus.getType());
            this.out.writeUTF(aStatus.getReason());
        }
        this.writers.clear();
    }

    void log(String string) {
        this.logWriter.printf("[%s] AgentServer[%d]: %s%n", logDateFormat.format(new Date()), this.id, string);
    }

    @Override
    public PrintWriter getPrintWriter(ActionHelper.OutputHandler.OutputKind outputKind, boolean bl) {
        return new PrintWriter(this.getWriter(outputKind), bl);
    }

    private Writer getWriter(final ActionHelper.OutputHandler.OutputKind outputKind) {
        Writer writer = this.writers.get((Object)outputKind);
        if (writer == null) {
            writer = new Writer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(char[] cArray, int n, int n2) throws IOException {
                    if (traceServer) {
                        AgentServer.this.traceOut.println("Agent.Server.write[" + outputKind + ",writer] " + new String(cArray, n, n2));
                    }
                    while (n2 > 0) {
                        int n3 = n2 > 4096 ? 4096 : n2;
                        DataOutputStream dataOutputStream = AgentServer.this.out;
                        synchronized (dataOutputStream) {
                            AgentServer.this.out.writeByte(3);
                            AgentServer.this.out.writeUTF(outputKind.name);
                            AgentServer.this.out.writeUTF(new String(cArray, n, n3));
                        }
                        n += n3;
                        n2 -= n3;
                    }
                    if (traceServer) {
                        AgentServer.this.traceOut.println("Agent.Server.write[" + outputKind + ",writer]--done");
                    }
                }

                @Override
                public void flush() throws IOException {
                    AgentServer.this.out.flush();
                }

                @Override
                public void close() throws IOException {
                    AgentServer.this.out.flush();
                }
            };
            this.writers.put(outputKind, writer);
        }
        return writer;
    }

    @Override
    public PrintStream getPrintStream(ActionHelper.OutputHandler.OutputKind outputKind, boolean bl) {
        return new PrintStream(this.getOutputStream(outputKind), bl);
    }

    private OutputStream getOutputStream(final ActionHelper.OutputHandler.OutputKind outputKind) {
        final Writer writer = this.getWriter(outputKind);
        return new OutputStream(){
            private static final int BUFSIZE = 1024;
            private ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
            private CharBuffer charBuffer = CharBuffer.allocate(1024);
            private CharsetDecoder decoder = Charset.forName(System.getProperty("sun.stdout.encoding", System.getProperty("sun.jnu.encoding", Charset.defaultCharset().name()))).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                int n3;
                if (traceServer) {
                    AgentServer.this.traceOut.println("Agent.Server.write[" + outputKind + ",stream] " + new String(byArray, n, n2));
                }
                while (n2 > 0 && n2 >= (n3 = this.byteBuffer.remaining())) {
                    this.byteBuffer.put(byArray, n, n3);
                    this.decode();
                    n += n3;
                    n2 -= n3;
                }
                this.byteBuffer.put(byArray, n, n2);
                if (traceServer) {
                    AgentServer.this.traceOut.println("Agent.Server.write[" + outputKind + ",stream]--done");
                }
            }

            @Override
            public void write(int n) throws IOException {
                this.byteBuffer.put((byte)n);
                if (!this.byteBuffer.hasRemaining()) {
                    this.decode();
                }
            }

            @Override
            public void flush() throws IOException {
                this.decode();
                writer.flush();
            }

            @Override
            public void close() throws IOException {
                this.decode();
                this.byteBuffer.flip();
                this.decoder.decode(this.byteBuffer, this.charBuffer, true);
                this.writeCharBuffer();
                writer.flush();
            }

            private void decode() throws IOException {
                CoderResult coderResult;
                this.byteBuffer.flip();
                while ((coderResult = this.decoder.decode(this.byteBuffer, this.charBuffer, false)) != CoderResult.UNDERFLOW) {
                    this.writeCharBuffer();
                }
                this.byteBuffer.compact();
            }

            private void writeCharBuffer() throws IOException {
                this.charBuffer.flip();
                writer.write(this.charBuffer.toString());
                this.charBuffer.clear();
            }
        };
    }

    public static class KeepAlive {
        public static final int WRITE_TIMEOUT = 60000;
        public static final int READ_TIMEOUT = 120000;
        final DataOutputStream out;
        final Runnable ping = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DataOutputStream dataOutputStream = out;
                    synchronized (dataOutputStream) {
                        if (trace) {
                            traceOut.println("KeepAlive.ping");
                        }
                        out.writeByte(5);
                        out.flush();
                    }
                    this.setEnabled(true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Alarm alarm = Alarm.NONE;
        final PrintStream traceOut = System.err;
        final boolean trace;

        public KeepAlive(DataOutputStream dataOutputStream, boolean bl) {
            this.out = dataOutputStream;
            this.trace = bl;
        }

        public synchronized void setEnabled(boolean bl) {
            this.alarm.cancel();
            this.alarm = bl ? Alarm.schedule(60000L, TimeUnit.MILLISECONDS, null, this.ping) : Alarm.NONE;
        }

        public synchronized void finished() {
            this.setEnabled(false);
        }
    }
}

