/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.tools;

import com.sun.tdk.jcov.tools.ScaleCompressor;
import com.sun.tdk.jcov.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class DeflaterScaleCompressor
implements ScaleCompressor {
    public static final String sccsVersion = "%I% $LastChangedDate: 2013-09-30 17:48:28 +0400 (Mon, 30 Sep 2013) $";
    protected static byte[] buf = new byte[2048];
    protected static final Deflater def = new Deflater(9, true);
    protected static final ByteArrayOutputStream bos = new ByteArrayOutputStream(512);
    protected static final DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)bos, def);
    protected static final Inflater inf = new Inflater(true);
    protected static final ByteArrayInputStream bis = new ByteArrayInputStream(buf);
    protected static final InflaterInputStream ios = new InflaterInputStream(bis, inf);

    @Override
    public void decompress(char[] src, int len, byte[] dst, int bits_total) throws Exception {
        for (int i = 0; i < len; ++i) {
            Utils.writeHalfByteAt(Utils.hexChar2Int(src[i]), i, buf);
        }
        int buf_len = (bits_total + 7) / 8;
        try {
            ios.read(dst, 0, buf_len);
            inf.reset();
            bis.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("invalid compression");
        }
    }

    @Override
    public int compress(byte[] src, StringBuffer dst, int bits_total) {
        try {
            dos.write(src, 0, (bits_total + 7) / 8);
            dos.finish();
            dos.flush();
            bos.flush();
        }
        catch (IOException e) {
            return -1;
        }
        byte[] res = bos.toByteArray();
        def.reset();
        bos.reset();
        if (res.length * 2 > dst.length()) {
            dst.setLength(res.length * 2);
        }
        for (int i = 0; i < res.length * 2; ++i) {
            dst.setCharAt(i, Utils.int2HexChar(Utils.getHalfByteAt(i, res)));
        }
        return res.length * 2;
    }
}

