/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.runtime;

import com.sun.tdk.jcov.runtime.Collect;
import com.sun.tdk.jcov.runtime.JCovSaver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PropertyFinder {
    private static Properties p;
    private static boolean propsRead;
    private static String propsFile;
    public static final String PROPERTY_FILE_PREFIX = "jcov.";
    public static final String JVM_PROPERTY_PREFIX = "jcov.";
    public static final String ENV_PROPERTY_PREFIX = "JCOV_";

    public static String processMacroString(String str) {
        return PropertyFinder.processMacroString(str, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String processMacroString(String str, char[] shortcarts, String[] datas) {
        if (str == null) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        int start = 0;
        int pos = 0;
        while (true) {
            if ((pos = str.indexOf(37, start)) < 0) {
                buf.append(str.substring(start));
                break;
            }
            buf.append(str.substring(start, pos));
            int end = str.indexOf(37, pos + 1);
            if (end < 0) {
                buf.append(str.substring(pos));
                break;
            }
            String patt = str.substring(pos, end);
            if (end - pos < 2) {
                buf.append('%');
            } else {
                boolean changed;
                char ch = patt.charAt(1);
                if (end - pos == 2) {
                    boolean found = false;
                    if (shortcarts != null) {
                        for (int i = 0; i < shortcarts.length; ++i) {
                            if (shortcarts[i] != ch) continue;
                            found = true;
                            buf.append(datas[i]);
                        }
                    }
                    if (!found) {
                        switch (ch) {
                            case 'd': {
                                Calendar c = Calendar.getInstance();
                                buf.append(c.get(11)).append(':').append(c.get(12)).append(':').append(c.get(13)).append('_').append(c.get(2) + 1).append('-').append(c.get(5)).append('-').append(c.get(1));
                                break;
                            }
                            case 't': {
                                Calendar c = Calendar.getInstance();
                                buf.append(c.get(11)).append(':').append(c.get(12)).append(':').append(c.get(13));
                                break;
                            }
                            case 'D': {
                                buf.append(System.getProperty("user.dir"));
                                break;
                            }
                            case 'R': {
                                buf.append(Math.round(Math.random() * 100000.0));
                                break;
                            }
                            case 'T': {
                                buf.append(System.currentTimeMillis());
                                break;
                            }
                            case 'U': {
                                buf.append(System.getProperty("user.name"));
                                break;
                            }
                            case 'V': {
                                buf.append(System.getProperty("java.version"));
                                break;
                            }
                            default: {
                                --end;
                                buf.append(patt);
                            }
                        }
                    }
                } else if (ch == 'F') {
                    String className = patt.substring(2, patt.lastIndexOf(46));
                    try {
                        Class<?> c = Class.forName(className);
                        Field f = c.getDeclaredField(patt.substring(patt.lastIndexOf(46) + 1, patt.length()));
                        changed = false;
                        if (!f.isAccessible()) {
                            f.setAccessible(true);
                            changed = true;
                        }
                        try {
                            if (f != null) {
                                buf.append(f.get(null).toString());
                            } else {
                                --end;
                                buf.append(patt);
                            }
                        }
                        finally {
                            if (changed) {
                                f.setAccessible(false);
                            }
                        }
                    }
                    catch (Exception e) {
                        --end;
                        buf.append(patt);
                    }
                } else if (ch == 'M') {
                    String className = patt.substring(2, patt.lastIndexOf(46));
                    try {
                        Class<?> c = Class.forName(className);
                        Method m = c.getDeclaredMethod(patt.substring(patt.lastIndexOf(46) + 1, patt.length()), null);
                        changed = false;
                        if (!m.isAccessible()) {
                            m.setAccessible(true);
                            changed = true;
                        }
                        try {
                            if (m != null && m.getReturnType() != Void.class) {
                                buf.append(m.invoke(null, (Object[])null).toString());
                            } else {
                                --end;
                                buf.append(patt);
                            }
                        }
                        finally {
                            if (changed) {
                                m.setAccessible(false);
                            }
                        }
                    }
                    catch (Exception e) {
                        --end;
                        buf.append(patt);
                    }
                } else if (ch == 'E') {
                    String prop = System.getenv(patt.substring(2));
                    if (prop != null) {
                        buf.append(prop);
                    } else {
                        --end;
                        buf.append(patt);
                    }
                } else if (ch == 'P') {
                    String prop = System.getProperty(patt.substring(2));
                    if (prop != null) {
                        buf.append(prop);
                    } else {
                        --end;
                        buf.append(patt);
                    }
                } else {
                    String prop = System.getProperty(patt.substring(1));
                    if (prop != null) {
                        buf.append(prop);
                    } else {
                        --end;
                        buf.append(patt);
                    }
                }
            }
            start = end + 1;
        }
        return buf.toString();
    }

    public static String getStaticValue(String name, String defaultValue) {
        try {
            String res = System.getProperty("jcov." + name);
            if (res != null) {
                return res;
            }
            res = System.getenv(ENV_PROPERTY_PREFIX + name.replaceAll("\\.", "_").toUpperCase());
            if (res != null) {
                return res;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static String findValue(String name, String defaultValue) {
        String res = PropertyFinder.getStaticValue(name, null);
        if (res == null) {
            Properties p = PropertyFinder.findProperties();
            res = p != null ? p.getProperty("jcov." + name, defaultValue) : defaultValue;
        }
        return PropertyFinder.processMacroString(res, null, null);
    }

    private static Properties findProperties() {
        if (!propsRead) {
            propsRead = true;
            String propfile = PropertyFinder.getStaticValue("propfile", null);
            if (propfile != null && (p = PropertyFinder.readProperties(propfile)) != null) {
                propsFile = propfile;
                return p;
            }
            if (!(propfile != null && "/com/sun/tdk/jcov/jcov.properties".equals(propfile) || (p = PropertyFinder.readProperties("/com/sun/tdk/jcov/jcov.properties")) == null)) {
                propsFile = "/com/sun/tdk/jcov/jcov.properties";
                return p;
            }
            p = PropertyFinder.readProperties(System.getProperty("user.home") + File.separator + ".jcov" + File.separator + "jcov.properties");
            if (p != null) {
                propsFile = System.getProperty("user.home") + File.separator + ".jcov" + File.separator + "jcov.properties";
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(String path) {
        InputStream in;
        File f = new File(path);
        if (f.exists() && f.isFile() && f.canRead()) {
            in = null;
            try {
                in = new FileInputStream(f);
                Properties p = new Properties();
                p.load(in);
                PropertyFinder.resolveProps(p);
                Properties properties = p;
                return properties;
            }
            catch (IOException p) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        in = null;
        try {
            in = JCovSaver.class.getResourceAsStream(path);
        }
        catch (Exception p) {
            // empty catch block
        }
        if (in != null) {
            try {
                Properties p = new Properties();
                p.load(in);
                PropertyFinder.resolveProps(p);
                Properties properties = p;
                return properties;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(String path, Properties p) {
        InputStream in;
        File f;
        if (p == null) {
            p = new Properties();
        }
        if ((f = new File(path)).exists() && f.isFile() && f.canRead()) {
            in = null;
            try {
                in = new FileInputStream(f);
                p.load(in);
                PropertyFinder.resolveProps(p);
                Properties properties = p;
                return properties;
            }
            catch (IOException iOException) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if ((in = JCovSaver.class.getResourceAsStream(path)) != null) {
            try {
                p.load(in);
                PropertyFinder.resolveProps(p);
                Properties properties = p;
                return properties;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return p;
    }

    private static void resolveProps(Properties props) {
        Pattern p = Pattern.compile(".*(\\$\\{(.*)\\})");
        for (Object o : props.keySet()) {
            String name = (String)o;
            String val = props.getProperty(name);
            Matcher m = p.matcher(val);
            while (m.find()) {
                String link = m.group(2);
                String lVal = props.getProperty(link);
                val = val.replace(m.group(1), lVal);
                m = p.matcher(val);
            }
            props.put(o, val);
        }
    }

    public static String readPropFrom(String fileName, String name) {
        Properties props = PropertyFinder.readProperties(fileName, null);
        if (props != null) {
            return props.getProperty("jcov." + name);
        }
        return null;
    }

    public static String findSource(String name) {
        if (name == null || "".equals(name)) {
            return "";
        }
        if (System.getProperty("jcov." + name) != null) {
            return "JavaVM property 'jcov." + name + "'";
        }
        if (System.getenv(ENV_PROPERTY_PREFIX + name.toUpperCase()) != null) {
            return "system environment property 'JCOV_" + name.toUpperCase() + "'";
        }
        if (!propsRead) {
            PropertyFinder.findProperties();
        }
        if (propsFile != null && p.containsKey("jcov." + name)) {
            return "property file from '" + propsFile + "'";
        }
        return "defaults";
    }

    public static void setPropertiesFile(String path) {
        propsFile = path;
        p = PropertyFinder.readProperties(path);
        propsRead = true;
    }

    public static void cleanProperties() {
        p = null;
        propsFile = null;
        propsRead = false;
    }

    public static void addAutoShutdownSave() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (Collect.saveAtShutdownEnabled && "true".equals(PropertyFinder.findValue("autosave", "true"))) {
                    Collect.disable();
                    Collect.saveResults();
                    Collect.enable();
                    Collect.saveAtShutdownEnabled = false;
                    Collect.saveEnabled = false;
                }
            }
        });
    }

    public static boolean isVMReady() {
        return System.out != null && Runtime.getRuntime() != null;
    }

    static {
        propsRead = false;
    }
}

