/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.runtime;

import com.sun.tdk.jcov.Merger;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataPackage;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.instrument.XmlContext;
import com.sun.tdk.jcov.io.Reader;
import com.sun.tdk.jcov.runtime.FileSaver;
import com.sun.tdk.jcov.util.RuntimeUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.List;

public class JCovXMLFileSaver
extends FileSaver {
    private static boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");

    public JCovXMLFileSaver(DataRoot root, InstrumentationOptions.MERGE mergeMode) {
        super(root, mergeMode);
    }

    public JCovXMLFileSaver(DataRoot root, String filename, String template, InstrumentationOptions.MERGE merge, boolean scales) {
        super(root, filename, template, merge, scales);
    }

    @Override
    public void saveResults(String filename) throws Exception {
        File file = new File(filename);
        FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
        for (int i = 50; i != 0; --i) {
            try {
                FileLock lock = channel.tryLock();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                XmlContext ctx = new XmlContext((OutputStream)os, this.root.getParams());
                ctx.setSkipNotCoveredClasses(this.agentdata);
                this.root.xmlGen(ctx);
                ctx.close();
                channel.truncate(0L);
                channel.write(ByteBuffer.wrap(os.toByteArray()));
                lock.release();
                channel.close();
                return;
            }
            catch (OverlappingFileLockException e) {
                Thread.sleep(50000L);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void mergeResults(String dest, String src, boolean scale) throws Exception {
        if (this.insertOnly) {
            String tmpname = dest + ".tmp";
            this.saveResults(tmpname);
            try {
                this.root = Reader.readXML(src, scale, null);
                DataRoot templRoot = Reader.readXML(tmpname, scale, null);
                List<DataPackage> packs = this.root.getPackages();
                for (DataPackage templPack : templRoot.getPackages()) {
                    boolean pInserted = false;
                    for (DataPackage pack : packs) {
                        if (!pack.getName().equals(templPack.getName())) continue;
                        for (DataClass clazzNew : templPack.getClasses()) {
                            boolean cInserted = false;
                            for (DataClass clazz : pack.getClasses()) {
                                if (!clazz.getName().equals(clazzNew.getName())) continue;
                                cInserted = true;
                                break;
                            }
                            if (cInserted) continue;
                            pack.getClasses().add(clazzNew);
                        }
                        pInserted = true;
                        break;
                    }
                    if (pInserted) continue;
                    this.root.addPackage(templPack);
                }
                this.root.setCount(templRoot.getCount());
                templRoot.destroy();
                this.saveResults(dest);
            }
            catch (Exception e) {
                throw new Error(e);
            }
            finally {
                new File(tmpname).delete();
            }
        }
        String tmpFileName = dest + RuntimeUtils.genSuffix();
        try {
            this.saveResults(tmpFileName);
            PrintStream ps = System.out;
            if (scale) {
                Merger.innerMain(new String[]{"-output", dest, "-scale", "-compress", tmpFileName, src}, ps);
            } else {
                Merger.innerMain(new String[]{"-output", dest, tmpFileName, src}, ps);
            }
        }
        finally {
            new File(tmpFileName).delete();
        }
    }
}

