/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.runtime;

import com.sun.tdk.jcov.runtime.JCovSaver;
import com.sun.tdk.jcov.runtime.PropertyFinder;
import com.sun.tdk.jcov.runtime.SaverDecorator;

public class Collect {
    public static final int MAX_SLOTS = 2000000;
    public static int SLOTS = 2000000;
    private static final int MAX_SAVERS = 10;
    private static int nextSlot = 0;
    private static long[] counts;
    private static long[] counts_;
    private static JCovSaver[] savers;
    private static int nextSaver;
    private static Class extension;
    private static final String saverClassnameString = "/*@BUILD_MODIFIED_SAVER_STRING@*/";
    public static boolean enabled;
    public static boolean saveEnabled;
    public static boolean saveAtShutdownEnabled;
    public static boolean isInitialized;
    public static boolean isInternal;

    public static int newSlot() {
        if (nextSlot >= counts.length) {
            long[] newCounts = new long[nextSlot * 2];
            System.arraycopy(counts, 0, newCounts, 0, counts.length);
            counts = newCounts;
            counts_ = newCounts;
        }
        return nextSlot++;
    }

    public static int slotCount() {
        return nextSlot;
    }

    public static void hit(int slot) {
        int n = slot;
        counts[n] = counts[n] + 1L;
    }

    public static void setSlot(int i) {
        nextSlot = i;
    }

    public static boolean wasHit(int slot) {
        return counts_[slot] != 0L;
    }

    public static long[] counts() {
        return counts_;
    }

    public static long countFor(int slot) {
        return counts_[slot];
    }

    public static void setCountFor(int slot, long count) {
        Collect.counts[slot] = count;
    }

    public static void enableCounts() {
        counts = new long[SLOTS];
        counts_ = counts;
    }

    public static void disable() {
        enabled = false;
    }

    public static void enable() {
        enabled = true;
    }

    public static synchronized void addSaver(JCovSaver saver) {
        Collect.savers[Collect.nextSaver++] = saver;
    }

    public static synchronized void setSaver(JCovSaver saver) {
        for (int i = 0; i < nextSaver; ++i) {
            Collect.savers[i] = null;
        }
        nextSaver = 0;
        Collect.addSaver(saver);
    }

    public static synchronized void saveResults() {
        if (!saveEnabled) {
            return;
        }
        counts = new long[counts.length];
        String s = PropertyFinder.findValue("saver", null);
        if (s != null) {
            String[] saver = new String[s.length()];
            int i = 0;
            while (s.length() > 0) {
                int k = s.indexOf(";");
                if (k == 0) {
                    s = s.substring(1);
                    continue;
                }
                if (k > 0) {
                    String newS = s.substring(0, k);
                    if (newS.length() > 0) {
                        saver[i++] = newS;
                    }
                    s = s.substring(k);
                    continue;
                }
                saver[i++] = s;
                break;
            }
            for (int j = 0; j < i; ++j) {
                try {
                    Collect.instantiateSaver(saver[j]).saveResults();
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        } else {
            for (int i = 0; i < nextSaver; ++i) {
                try {
                    savers[i].saveResults();
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        counts_ = counts;
    }

    public static void loadSaverExtension() {
        if (extension != null) {
            return;
        }
        String m = PropertyFinder.findValue("extension", null);
        if (m != null) {
            if (m.equals("javatest") || m.equals("jt") || m.equals("jtreg")) {
                m = "com.sun.tdk.jcov.runtime.NetworkSatelliteDecorator";
            }
            try {
                extension = Class.forName(m);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static JCovSaver instantiateSaver(String name) {
        try {
            return Collect.decorateSaver((JCovSaver)Class.forName(name).newInstance());
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static JCovSaver decorateSaver(JCovSaver saver) {
        if (extension != null) {
            try {
                SaverDecorator s = (SaverDecorator)extension.newInstance();
                s.init(saver);
                return s;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return saver;
    }

    public static void init() {
        if (!isInitialized && !isInternal) {
            isInternal = true;
            if (PropertyFinder.isVMReady()) {
                Collect.loadSaverExtension();
                if (!saverClassnameString.startsWith("/*@")) {
                    Collect.addSaver(Collect.instantiateSaver(saverClassnameString));
                    PropertyFinder.addAutoShutdownSave();
                    isInitialized = true;
                } else {
                    isInitialized = true;
                }
            }
            isInternal = false;
        }
    }

    static {
        savers = new JCovSaver[10];
        nextSaver = 0;
        extension = null;
        enabled = false;
        saveEnabled = true;
        saveAtShutdownEnabled = true;
        isInitialized = false;
        isInternal = false;
        Collect.enableCounts();
        Collect.init();
    }
}

