/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report.html;

import java.util.HashMap;

public class JavaToHtml {
    private static HashMap reservedWords = new HashMap();
    private static boolean inMultiLineComment = false;
    private static String commentStart = "<span Class=\"comment\">";
    private static String commentEnd = "</span>";
    private static String stringStart = "<span Class=\"string\">";
    private static String stringEnd = "</span>";
    private static String reservedWordStart = "<span Class=\"keyword\">";
    private static String reservedWordEnd = "</span>";

    public static String syntaxHighlight(String line) {
        return JavaToHtml.htmlFilter(line);
    }

    private static String htmlFilter(String line) {
        if (line == null || line.equals("")) {
            return "";
        }
        line = JavaToHtml.replace(line, "&", "&#38;");
        line = JavaToHtml.replace(line, "\\\\", "&#92;&#92;");
        line = JavaToHtml.replace(line, "\\\"", "&#92;&#34");
        line = JavaToHtml.replace(line, "<", "&#60;");
        line = JavaToHtml.replace(line, ">", "&#62;");
        return JavaToHtml.multiLineCommentFilter(line);
    }

    private static String multiLineCommentFilter(String line) {
        int index;
        if (line == null || line.equals("")) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (inMultiLineComment && (index = line.indexOf("*/")) > -1 && !JavaToHtml.isInsideString(line, index)) {
            inMultiLineComment = false;
            buf.append(commentStart);
            buf.append(line.substring(0, index));
            buf.append("*/").append(commentEnd);
            if (line.length() > index + 2) {
                buf.append(JavaToHtml.inlineCommentFilter(line.substring(index + 2)));
            }
            return buf.toString();
        }
        if (inMultiLineComment) {
            buf.append(commentStart);
            buf.append(line);
            buf.append(commentEnd);
            return buf.toString();
        }
        index = line.indexOf("/*");
        if (index > -1 && !JavaToHtml.isInsideString(line, index)) {
            inMultiLineComment = true;
            buf.append(JavaToHtml.inlineCommentFilter(line.substring(0, index)));
            buf.append(commentStart).append("/*");
            buf.append(JavaToHtml.multiLineCommentFilter(line.substring(index + 2)));
            buf.append(commentEnd);
            return buf.toString();
        }
        return JavaToHtml.inlineCommentFilter(line);
    }

    private static String inlineCommentFilter(String line) {
        if (line == null || line.equals("")) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int index = line.indexOf("//");
        if (index > -1 && !JavaToHtml.isInsideString(line, index)) {
            buf.append(JavaToHtml.stringFilter(line.substring(0, index)));
            buf.append(commentStart);
            buf.append(line.substring(index));
            buf.append(commentEnd);
        } else {
            buf.append(JavaToHtml.stringFilter(line));
        }
        return buf.toString();
    }

    private static String stringFilter(String line) {
        int tempIndex;
        if (line == null || line.equals("")) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (line.indexOf("\"") <= -1) {
            return JavaToHtml.keywordFilter(line);
        }
        int start = 0;
        int startStringIndex = -1;
        int endStringIndex = -1;
        while ((tempIndex = line.indexOf("\"")) > -1) {
            if (startStringIndex == -1) {
                startStringIndex = 0;
                buf.append(JavaToHtml.stringFilter(line.substring(start, tempIndex)));
                buf.append(stringStart).append("\"");
                line = line.substring(tempIndex + 1);
                continue;
            }
            startStringIndex = -1;
            endStringIndex = tempIndex;
            buf.append(line.substring(0, endStringIndex + 1));
            buf.append(stringEnd);
            line = line.substring(endStringIndex + 1);
        }
        buf.append(JavaToHtml.keywordFilter(line));
        return buf.toString();
    }

    private static String keywordFilter(String line) {
        if (line == null || line.equals("")) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        HashMap usedReservedWords = new HashMap();
        int i = 0;
        int startAt = 0;
        StringBuffer temp = new StringBuffer();
        while (i < line.length()) {
            temp.setLength(0);
            char ch = line.charAt(i);
            startAt = i;
            while (i < line.length() && (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_')) {
                temp.append(ch);
                if (++i >= line.length()) continue;
                ch = line.charAt(i);
            }
            String tempString = temp.toString();
            if (reservedWords.containsKey(tempString) && !usedReservedWords.containsKey(tempString)) {
                line = JavaToHtml.replace(line, tempString, reservedWordStart + tempString + reservedWordEnd, startAt, true);
                i += reservedWordStart.length() + reservedWordEnd.length();
                continue;
            }
            ++i;
        }
        buf.append(line);
        return buf.toString();
    }

    private static String replace(String line, String oldString, String newString) {
        return JavaToHtml.replace(line, oldString, newString, 0, false);
    }

    private static String replace(String line, String oldString, String newString, int startAt, boolean once) {
        int i = startAt;
        while ((i = line.indexOf(oldString, i)) >= 0) {
            line = new StringBuffer().append(line.substring(0, i)).append(newString).append(line.substring(i + oldString.length())).toString();
            i += newString.length();
            if (!once) continue;
            break;
        }
        return line;
    }

    private static boolean isInsideString(String line, int position) {
        int index;
        if (line.indexOf("\"") < 0) {
            return false;
        }
        String left = line.substring(0, position);
        String right = line.substring(position);
        int leftCount = 0;
        int rightCount = 0;
        while ((index = left.indexOf("\"")) > -1) {
            ++leftCount;
            left = left.substring(index + 1);
        }
        while ((index = right.indexOf("\"")) > -1) {
            ++rightCount;
            right = right.substring(index + 1);
        }
        return rightCount % 2 != 0 && leftCount % 2 != 0;
    }

    private static void loadHash() {
        reservedWords.put("abstract", "abstract");
        reservedWords.put("assert", "assert");
        reservedWords.put("boolean", "boolean");
        reservedWords.put("break", "break");
        reservedWords.put("byte", "byte");
        reservedWords.put("case", "case");
        reservedWords.put("catch", "catch");
        reservedWords.put("char", "char");
        reservedWords.put("class", "class");
        reservedWords.put("const", "const");
        reservedWords.put("continue", "continue");
        reservedWords.put("default", "default");
        reservedWords.put("do", "do");
        reservedWords.put("double", "double");
        reservedWords.put("else", "else");
        reservedWords.put("enum", "enum");
        reservedWords.put("extends", "extends");
        reservedWords.put("false", "false");
        reservedWords.put("final", "final");
        reservedWords.put("finally", "finally");
        reservedWords.put("float", "float");
        reservedWords.put("for", "for");
        reservedWords.put("goto", "goto");
        reservedWords.put("if", "if");
        reservedWords.put("implements", "implements");
        reservedWords.put("import", "import");
        reservedWords.put("instanceof", "instanceof");
        reservedWords.put("int", "int");
        reservedWords.put("interface", "interface");
        reservedWords.put("long", "long");
        reservedWords.put("native", "native");
        reservedWords.put("new", "new");
        reservedWords.put("null", "null");
        reservedWords.put("package", "package");
        reservedWords.put("private", "private");
        reservedWords.put("protected", "protected");
        reservedWords.put("public", "public");
        reservedWords.put("return", "return");
        reservedWords.put("short", "short");
        reservedWords.put("static", "static");
        reservedWords.put("strictfp", "strictfp");
        reservedWords.put("super", "super");
        reservedWords.put("switch", "switch");
        reservedWords.put("synchronized", "synchronized");
        reservedWords.put("this", "this");
        reservedWords.put("throw", "throw");
        reservedWords.put("throws", "throws");
        reservedWords.put("transient", "transient");
        reservedWords.put("true", "true");
        reservedWords.put("try", "try");
        reservedWords.put("void", "void");
        reservedWords.put("volatile", "volatile");
        reservedWords.put("while", "while");
    }

    static {
        JavaToHtml.loadHash();
    }
}

