/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report.ancfilters;

import com.sun.tdk.jcov.report.AncFilter;
import com.sun.tdk.jcov.report.AncFilterFactory;
import com.sun.tdk.jcov.report.ParameterizedAncFilter;
import com.sun.tdk.jcov.report.ancfilters.CatchANCFilter;
import com.sun.tdk.jcov.report.ancfilters.DeprecatedANCFilter;
import com.sun.tdk.jcov.report.ancfilters.EmptyANCFilter;
import com.sun.tdk.jcov.report.ancfilters.GetterANCFilter;
import com.sun.tdk.jcov.report.ancfilters.ListANCFilter;
import com.sun.tdk.jcov.report.ancfilters.SetterANCFilter;
import com.sun.tdk.jcov.report.ancfilters.SyntheticANCFilter;
import com.sun.tdk.jcov.report.ancfilters.ThrowANCFilter;
import com.sun.tdk.jcov.report.ancfilters.ToStringANCFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BuiltInAncFilters
implements AncFilterFactory {
    private static final Map<String, Class<? extends AncFilter>> filterClasses = new HashMap<String, Class<? extends AncFilter>>();

    @Override
    public AncFilter instantiate(String shortName) {
        try {
            return filterClasses.get(shortName).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to instantiate filter " + shortName, e);
        }
    }

    @Override
    public Collection<AncFilter> instantiateAll() {
        ArrayList<AncFilter> filters = new ArrayList<AncFilter>();
        for (Class<? extends AncFilter> cls : filterClasses.values()) {
            if (ParameterizedAncFilter.class.isAssignableFrom(cls)) continue;
            try {
                filters.add(cls.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Unable to instantiate filter " + cls.getName(), e);
            }
        }
        return filters;
    }

    static {
        filterClasses.put("catch", CatchANCFilter.class);
        filterClasses.put("deprecated", DeprecatedANCFilter.class);
        filterClasses.put("empty", EmptyANCFilter.class);
        filterClasses.put("getter", GetterANCFilter.class);
        filterClasses.put("list", ListANCFilter.class);
        filterClasses.put("setter", SetterANCFilter.class);
        filterClasses.put("synthetic", SyntheticANCFilter.class);
        filterClasses.put("throw", ThrowANCFilter.class);
        filterClasses.put("toString", ToStringANCFilter.class);
    }
}

