/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report;

import com.sun.tdk.jcov.data.Scale;
import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataBlockTarget;
import com.sun.tdk.jcov.instrument.DataBlockTargetCond;
import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.report.AncFilter;
import com.sun.tdk.jcov.report.CoverageData;
import com.sun.tdk.jcov.report.DataType;
import com.sun.tdk.jcov.report.ItemCoverage;
import com.sun.tdk.jcov.report.LineCoverage;
import com.sun.tdk.jcov.report.MemberCoverage;
import com.sun.tdk.jcov.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MethodCoverage
extends MemberCoverage
implements Iterable<ItemCoverage> {
    private LineCoverage lineCoverage = new LineCoverage();
    private List<ItemCoverage> items = new ArrayList<ItemCoverage>();
    private boolean inAnonymClass = false;
    private boolean lambdaMethod = false;
    private boolean anonymon = false;
    private DataType[] supportedColumns = new DataType[]{DataType.METHOD, DataType.BLOCK, DataType.BRANCH, DataType.LINE};
    private boolean isInAnc = false;
    protected String ancInfo;
    public static final int CT_FIRST_KIND = 1;
    public static final int CT_METHOD = 1;
    public static final int CT_FIKT_METHOD = 2;
    public static final int CT_BLOCK = 3;
    public static final int CT_FIKT_RET = 4;
    public static final int CT_CASE = 5;
    public static final int CT_SWITCH_WO_DEF = 6;
    public static final int CT_BRANCH_TRUE = 7;
    public static final int CT_BRANCH_FALSE = 8;
    public static final int CT_LINE = 9;
    public static final int CT_LAST_KIND = 9;

    public MethodCoverage(DataMethod method, AncFilter[] ancFilters, String ancReason) {
        this(method, false, ancFilters, ancReason);
    }

    public MethodCoverage(DataMethod method, boolean countBlocks) {
        this(method, countBlocks, null, null);
    }

    public MethodCoverage(DataMethod method, boolean countBlocks, AncFilter[] ancFilters, String ancReason) {
        this.modifiers = Arrays.deepToString(method.getAccessFlags());
        this.name = method.getName();
        this.scale = method.getScale();
        this.signature = method.getVmSignature();
        this.access = method.getAccess();
        this.isInAnc = ancReason != null;
        this.ancInfo = ancReason;
        if (this.signature == null) {
            this.signature = "";
        }
        this.count = method.getCount();
        this.detectItems(method, this.items, this.isInAnc, ancFilters);
        List<DataMethod.LineEntry> lineTable = method.getLineTable();
        if (lineTable != null) {
            if (lineTable.size() > 0) {
                this.startLine = lineTable.get((int)0).line;
            }
            this.lineCoverage.processLineTable(lineTable);
            for (ItemCoverage item : this.items) {
                for (DataMethod.LineEntry le : lineTable) {
                    if (le.bci < item.startLine || le.bci > item.endLine) continue;
                    if (item.count > 0L) {
                        this.lineCoverage.hitLine(le.line);
                    } else if (this.isInAnc || item.isInAnc()) {
                        this.lineCoverage.markLineAnc(le.line);
                    }
                    if (item.getSourceLine() >= 0) continue;
                    item.setSrcLine(le.line);
                }
                if (item.getSourceLine() >= 0 || lineTable.size() <= 0) continue;
                item.setSrcLine(lineTable.get((int)(lineTable.size() - 1)).line);
            }
        }
    }

    private static String isBlockInAnc(DataMethod m, DataBlock b, AncFilter[] filters, List<String> ancBlockReasons) {
        if (filters == null) {
            return null;
        }
        for (AncFilter filter : filters) {
            if (!filter.accept(m, b)) continue;
            String ancReason = filter.getAncReason();
            if (ancBlockReasons.size() == 0) {
                ancBlockReasons.add("All blocks are filtered:");
            }
            if (!ancBlockReasons.contains(ancReason)) {
                ancBlockReasons.add(ancReason);
            }
            return ancReason;
        }
        return null;
    }

    public void setAnonymOn(boolean anonym) {
        this.anonymon = anonym;
    }

    public void setInAnonymClass(boolean inAnonymClass) {
        this.inAnonymClass = inAnonymClass;
    }

    public boolean isInAnonymClass() {
        return this.inAnonymClass;
    }

    public void setLambdaMethod(boolean lambdaMethod) {
        this.lambdaMethod = lambdaMethod;
    }

    public boolean isLambdaMethod() {
        return this.lambdaMethod;
    }

    void detectItems(DataMethod m, List<ItemCoverage> list, boolean isInAnc, AncFilter[] ancFilters) {
        int i;
        boolean isNew;
        String ancReason;
        ItemCoverage item;
        int type;
        HashMap<DataBlock, ItemCoverage> added = new HashMap<DataBlock, ItemCoverage>();
        ArrayList<String> ancBlockReasons = new ArrayList<String>();
        for (DataBlock dataBlock : m.getBlocks()) {
            if (dataBlock instanceof DataBlockTarget) continue;
            type = MethodCoverage.type(dataBlock);
            item = null;
            item = type == 3 ? ItemCoverage.createBlockCoverageItem(dataBlock.startBCI(), dataBlock.endBCI(), dataBlock.getCount(), dataBlock.getScale()) : ItemCoverage.createBranchCoverageItem(dataBlock.startBCI(), dataBlock.endBCI(), dataBlock.getCount(), dataBlock.getScale());
            ancReason = MethodCoverage.isBlockInAnc(m, dataBlock, ancFilters, ancBlockReasons);
            if (isInAnc || ancReason != null) {
                item.setAncInfo(this.ancInfo != null ? this.ancInfo : ancReason);
            }
            isNew = true;
            for (DataBlock d : added.keySet()) {
                if (d.startBCI() != dataBlock.startBCI() || MethodCoverage.type(d) != MethodCoverage.type(dataBlock) || !((ItemCoverage)added.get(d)).isBlock()) continue;
                ((ItemCoverage)added.get((Object)d)).count += dataBlock.getCount();
                if (((ItemCoverage)added.get((Object)d)).scale != null && dataBlock.getScale() != null) {
                    for (i = 0; i < ((ItemCoverage)added.get((Object)d)).scale.size(); ++i) {
                        if (!dataBlock.getScale().isBitSet(i)) continue;
                        ((ItemCoverage)added.get((Object)d)).scale.setBit(i, true);
                    }
                }
                isNew = false;
                break;
            }
            if (!isNew) continue;
            added.put(dataBlock, item);
            if (type == 1) continue;
            list.add(item);
        }
        for (DataBlockTarget dataBlockTarget : m.getBranchTargets()) {
            type = MethodCoverage.type(dataBlockTarget);
            item = null;
            item = type == 3 ? ItemCoverage.createBlockCoverageItem(dataBlockTarget.startBCI(), dataBlockTarget.endBCI(), dataBlockTarget.getCount(), dataBlockTarget.getScale()) : ItemCoverage.createBranchCoverageItem(dataBlockTarget.startBCI(), dataBlockTarget.endBCI(), dataBlockTarget.getCount(), dataBlockTarget.getScale());
            ancReason = MethodCoverage.isBlockInAnc(m, dataBlockTarget, ancFilters, ancBlockReasons);
            if (isInAnc || ancReason != null) {
                item.setAncInfo(this.ancInfo != null ? this.ancInfo : ancReason);
            }
            isNew = true;
            for (DataBlock d : added.keySet()) {
                if (d.startBCI() != dataBlockTarget.startBCI() || MethodCoverage.type(d) != MethodCoverage.type(dataBlockTarget) || !((ItemCoverage)added.get(d)).isBlock()) continue;
                ((ItemCoverage)added.get((Object)d)).count += dataBlockTarget.getCount();
                if (((ItemCoverage)added.get((Object)d)).scale != null && dataBlockTarget.getScale() != null) {
                    for (i = 0; i < ((ItemCoverage)added.get((Object)d)).scale.size(); ++i) {
                        if (!dataBlockTarget.getScale().isBitSet(i)) continue;
                        ((ItemCoverage)added.get((Object)d)).scale.setBit(i, true);
                    }
                }
                isNew = false;
                break;
            }
            if (!isNew) continue;
            added.put(dataBlockTarget, item);
            list.add(item);
        }
        for (DataBlock dataBlock : added.keySet()) {
            ItemCoverage i2 = (ItemCoverage)added.get(dataBlock);
            if (i2.isBlock()) continue;
            ItemCoverage i22 = ItemCoverage.createBlockCoverageItem(i2.startLine, i2.endLine, i2.count, dataBlock.getScale());
            ancReason = MethodCoverage.isBlockInAnc(m, dataBlock, ancFilters, ancBlockReasons);
            if (isInAnc || ancReason != null) {
                i22.setAncInfo(this.ancInfo != null ? this.ancInfo : ancReason);
            }
            isNew = true;
            for (DataBlock d : added.keySet()) {
                if (d.startBCI() != dataBlock.startBCI() || !((ItemCoverage)added.get(d)).isBlock()) continue;
                ((ItemCoverage)added.get((Object)d)).count += dataBlock.getCount();
                if (((ItemCoverage)added.get((Object)d)).scale != null && dataBlock.getScale() != null) {
                    Scale s = Scale.createZeroScale(((ItemCoverage)added.get((Object)d)).scale.size());
                    for (int j = 0; j < ((ItemCoverage)added.get((Object)d)).scale.size(); ++j) {
                        if (!((ItemCoverage)added.get((Object)d)).scale.isBitSet(j) && !dataBlock.getScale().isBitSet(j)) continue;
                        s.setBit(j, true);
                    }
                    ((ItemCoverage)added.get((Object)d)).scale = s;
                }
                isNew = false;
                break;
            }
            if (!isNew) continue;
            added.put(dataBlock, i22);
            list.add(i22);
        }
        if (!isInAnc && ancBlockReasons.size() - 1 == list.size()) {
            StringBuilder methodAncReason = new StringBuilder();
            for (String ancBlock : ancBlockReasons) {
                methodAncReason.append(" ").append(ancBlock);
            }
            this.setAncInfo(methodAncReason.toString());
        }
    }

    public void setAncInfo(String ancInfo) {
        this.isInAnc = ancInfo != null && !ancInfo.isEmpty();
        this.ancInfo = ancInfo;
    }

    public boolean isMethodInAnc() {
        return this.isInAnc;
    }

    public String getAncInfo() {
        return this.ancInfo;
    }

    public static int type(DataBlock db) {
        String type = db.kind();
        if (type.equals("methenter")) {
            return 1;
        }
        if (type.equals("cond")) {
            DataBlockTargetCond cond = (DataBlockTargetCond)db;
            return cond.side() ? 7 : 8;
        }
        if (type.equals("case")) {
            return 5;
        }
        if (type.equals("default")) {
            return 6;
        }
        return 3;
    }

    public List<ItemCoverage> getItems() {
        return this.items;
    }

    @Override
    public Iterator<ItemCoverage> iterator() {
        return this.items.iterator();
    }

    public LineCoverage getLineCoverage() {
        return this.lineCoverage;
    }

    @Override
    public DataType getDataType() {
        return DataType.METHOD;
    }

    @Override
    public CoverageData getData(DataType column) {
        return this.getData(column, -1);
    }

    @Override
    public CoverageData getData(DataType column, int testNumber) {
        switch (column) {
            case METHOD: {
                int c;
                if (this.inAnonymClass && !this.anonymon) {
                    return new CoverageData(0, 0, 0);
                }
                if (this.name.startsWith("lambda$")) {
                    return new CoverageData(0, 0, 0);
                }
                if (testNumber > -1) {
                    int c2;
                    int n = c2 = this.count > 0L && this.isCoveredByTest(testNumber) ? 1 : 0;
                    if (this.isInAnc) {
                        return new CoverageData(c2, 1 - c2, 1);
                    }
                    return new CoverageData(c2, 0, 1);
                }
                int n = c = this.count > 0L ? 1 : 0;
                if (this.isInAnc) {
                    return new CoverageData(c, 1 - c, 1);
                }
                return new CoverageData(c, 0, 1);
            }
            case BLOCK: 
            case BRANCH: {
                if (this.inAnonymClass && !this.anonymon && (this.access & 0x1000) != 0) {
                    return new CoverageData(0, 0, 0);
                }
                CoverageData result = new CoverageData(0, 0, 0);
                for (ItemCoverage item : this.items) {
                    if (testNumber < 0 || item.isCoveredByTest(testNumber)) {
                        result.add(item.getData(column));
                        continue;
                    }
                    CoverageData icov = item.getData(column);
                    if (this.isInAnc) {
                        result.add(new CoverageData(0, 1, icov.getTotal()));
                        continue;
                    }
                    result.add(new CoverageData(0, icov.getAnc(), icov.getTotal()));
                }
                return result;
            }
            case LINE: {
                return this.lineCoverage;
            }
        }
        return new CoverageData();
    }

    @Override
    protected DataType[] getDataTypes() {
        return this.supportedColumns;
    }

    @Override
    public String getReadableSignature() {
        return Utils.convertVMtoJLS(this.name, this.signature);
    }

    public boolean isLineCovered(int lineNumber) {
        return this.lineCoverage.isLineCovered(lineNumber);
    }
}

