/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report;

import com.sun.tdk.jcov.data.Scale;
import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.report.AbstractCoverage;
import com.sun.tdk.jcov.report.CoverageData;
import com.sun.tdk.jcov.report.DataType;

public abstract class ItemCoverage
extends AbstractCoverage {
    protected final int startLine;
    protected final int endLine;
    protected long count;
    private int srcLine = -1;
    protected Scale scale;
    protected boolean isInAnc = false;
    protected String ancInfo;

    public static ItemCoverage createBlockCoverageItem(DataBlock b) {
        return ItemCoverage.createBlockCoverageItem(b.startBCI(), b.endBCI(), b.getCount(), b.getScale());
    }

    public static ItemCoverage createBlockCoverageItem(int startBCI, int endBCI, long cnt) {
        return new BlockCoverage(startBCI, endBCI, cnt, null);
    }

    public static ItemCoverage createBlockCoverageItem(int startBCI, int endBCI, long cnt, Scale scale) {
        return new BlockCoverage(startBCI, endBCI, cnt, scale);
    }

    public static ItemCoverage createBranchCoverageItem(DataBlock b) {
        return ItemCoverage.createBranchCoverageItem(b.startBCI(), b.endBCI(), b.getCount(), b.getScale());
    }

    public static ItemCoverage createBranchCoverageItem(int startBCI, int endBCI, long cnt) {
        return new BranchCoverage(startBCI, endBCI, cnt, null);
    }

    public static ItemCoverage createBranchCoverageItem(int startBCI, int endBCI, long cnt, Scale scale) {
        return new BranchCoverage(startBCI, endBCI, cnt, scale);
    }

    protected ItemCoverage(int startLine, int endLine, long count, Scale scale) {
        this.startLine = startLine;
        this.endLine = endLine;
        this.count = count;
        this.scale = scale;
    }

    public boolean isInAnc() {
        return this.isInAnc;
    }

    public void setAncInfo(String ancInfo) {
        this.isInAnc = true;
        this.ancInfo = ancInfo;
    }

    public String getAncInfo() {
        return this.ancInfo;
    }

    protected void setSrcLine(int srcLine) {
        this.srcLine = srcLine;
    }

    public int getSourceLine() {
        return this.srcLine;
    }

    public long getCount() {
        return this.count;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public abstract boolean isBlock();

    @Override
    public boolean isCovered() {
        return this.count > 0L;
    }

    @Override
    public boolean isCoveredByTest(int testnum) {
        return this.scale != null && this.scale.isBitSet(testnum);
    }

    public String toString() {
        String b = this.isBlock() ? "BLOCK  " : "BRANCH ";
        return b + this.startLine + ":" + this.endLine + "   " + this.count;
    }

    public static DataType[] getAllPossibleTypes() {
        return new DataType[]{DataType.BLOCK, DataType.BRANCH};
    }

    private static class BlockCoverage
    extends ItemCoverage {
        private BlockCoverage(DataBlock dataBlock) {
            this(dataBlock.startBCI(), dataBlock.endBCI(), dataBlock.getCount(), dataBlock.getScale());
        }

        private BlockCoverage(int startBCI, int endBCI, long cnt, Scale scale) {
            super(startBCI, endBCI, cnt, scale);
        }

        @Override
        public DataType getDataType() {
            return DataType.BLOCK;
        }

        @Override
        protected DataType[] getDataTypes() {
            return new DataType[]{DataType.BLOCK};
        }

        @Override
        public CoverageData getData(DataType column) {
            return this.getData(column, -1);
        }

        @Override
        public CoverageData getData(DataType column, int testNumber) {
            switch (column) {
                case BLOCK: {
                    int value;
                    int n = value = this.count == 0L ? 0 : 1;
                    if (this.isInAnc) {
                        return new CoverageData(value, 1 - value, 1);
                    }
                    return new CoverageData(value, 0, 1);
                }
            }
            return new CoverageData();
        }

        @Override
        public String getName() {
            return "block";
        }

        @Override
        public boolean isBlock() {
            return true;
        }
    }

    private static class BranchCoverage
    extends ItemCoverage {
        private BranchCoverage(int startBCI, int endBCI, long cnt, Scale scale) {
            super(startBCI, endBCI, cnt, scale);
        }

        @Override
        public DataType getDataType() {
            return DataType.BRANCH;
        }

        @Override
        protected DataType[] getDataTypes() {
            return new DataType[]{DataType.BRANCH};
        }

        @Override
        public CoverageData getData(DataType column) {
            return this.getData(column, -1);
        }

        @Override
        public CoverageData getData(DataType column, int testNumber) {
            switch (column) {
                case BRANCH: {
                    int value;
                    int n = value = this.count == 0L ? 0 : 1;
                    if (this.isInAnc) {
                        return new CoverageData(value, 1 - value, 1);
                    }
                    return new CoverageData(value, 0, 1);
                }
            }
            return new CoverageData();
        }

        @Override
        public String getName() {
            return "branch";
        }

        @Override
        public boolean isBlock() {
            return false;
        }
    }
}

