/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report;

import com.sun.tdk.jcov.report.AbstractCoverage;

public class CoverageData {
    protected int covered;
    protected int total;
    protected int anc;
    public static final AbstractCoverage.CoverageANCFormatter defaultFormatter = new AbstractCoverage.PercentFormatter();

    public CoverageData() {
        this.total = 0;
        this.anc = 0;
        this.covered = 0;
    }

    public CoverageData(int covered, int anc, int total) {
        this.covered = covered;
        this.total = total;
        this.anc = anc;
    }

    public int getAnc() {
        return this.anc;
    }

    public void setAnc(int anc) {
        this.anc = anc;
    }

    public int getCovered() {
        return this.covered;
    }

    public void setCovered(int covered) {
        this.covered = covered;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public CoverageData add(CoverageData data) {
        this.covered += data.covered;
        this.total += data.total;
        this.anc += data.anc;
        return this;
    }

    public String getFormattedCoverage() {
        return this.getFormattedCoverage(false);
    }

    public String getFormattedCoverage(boolean withANC) {
        return defaultFormatter.format(this, withANC);
    }

    public String getFormattedCoverage(AbstractCoverage.CoverageFormatter f) {
        return f.format(this);
    }

    public String getFormattedCoverage(AbstractCoverage.CoverageANCFormatter f, boolean withANC) {
        return f.format(this, withANC);
    }

    public String toString() {
        if (this.total == 0) {
            return "-";
        }
        if (this.anc == 0) {
            return String.format("%d/%d", this.covered, this.total);
        }
        return String.format("%d/%d/%d", this.covered, this.anc, this.total);
    }
}

