/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report;

import com.sun.tdk.jcov.report.CoverageData;
import com.sun.tdk.jcov.report.DataType;
import com.sun.tdk.jcov.util.NaturalComparator;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCoverage
implements Comparable {
    public abstract DataType getDataType();

    public abstract CoverageData getData(DataType var1);

    public abstract CoverageData getData(DataType var1, int var2);

    public abstract String getName();

    public abstract boolean isCovered();

    public abstract boolean isCoveredByTest(int var1);

    protected abstract DataType[] getDataTypes();

    public final boolean isSupported(DataType kind) {
        for (DataType name : this.getDataTypes()) {
            if (!name.equals((Object)kind)) continue;
            return true;
        }
        return false;
    }

    public final String getCoverageString(DataType type) {
        return this.getCoverageString(type, false);
    }

    public final String getCoverageString(DataType type, boolean withAnc) {
        CoverageData data = this.getData(type);
        return data.getFormattedCoverage(withAnc);
    }

    public final String getCoverageString(DataType type, CoverageFormatter f) {
        CoverageData data = this.getData(type);
        return data.getFormattedCoverage(f);
    }

    public final String getCoverageString(DataType type, CoverageANCFormatter f, boolean withAnc) {
        CoverageData data = this.getData(type);
        return data.getFormattedCoverage(f, withAnc);
    }

    public int compareTo(Object obj) {
        return NaturalComparator.INSTANCE.compare(this.getName(), ((AbstractCoverage)obj).getName());
    }

    public List<String> getCoveringTests(String[] testlist) {
        ArrayList<String> list = new ArrayList<String>(testlist.length / 10);
        for (int i = 0; i < testlist.length; ++i) {
            if (!this.isCoveredByTest(i)) continue;
            list.add(testlist[i]);
        }
        return list;
    }

    public static interface CoverageFormatter {
        public String format(CoverageData var1);
    }

    public static interface CoverageANCFormatter {
        public String format(CoverageData var1, boolean var2);
    }

    public static class PercentFormatter
    implements CoverageFormatter,
    CoverageANCFormatter {
        @Override
        public String format(CoverageData data) {
            if (data.total == 0) {
                return " -";
            }
            return String.format("%0$4.0f%% (%d/%d)", (double)((float)data.covered / (float)data.total) * 100.0, data.covered, data.total);
        }

        @Override
        public String format(CoverageData data, boolean withAnc) {
            if (data.total == 0) {
                return " -";
            }
            if (!withAnc) {
                return String.format("%0$4.0f%% (%d/%d)", (double)((float)data.covered / (float)data.total) * 100.0, data.covered, data.total);
            }
            return String.format("%0$4.0f%% (%d/%d/%d)", (double)((float)(data.covered + data.anc) / (float)data.total) * 100.0, data.covered, data.anc, data.total);
        }
    }
}

