/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument.reader;

import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.instrument.reader.Reader;
import java.io.InputStream;
import java.util.HashMap;

public abstract class ReaderFactory {
    protected int javaVersion;
    protected HashMap<Class, Reader> readers;
    protected Object processingData;

    public static ReaderFactory newInstance(int javaVersion, InputStream is) {
        String rName = ReaderFactory.class.getName();
        rName = rName + "StAX";
        try {
            ReaderFactory r = (ReaderFactory)Class.forName(rName).newInstance();
            r.javaVersion = javaVersion;
            r.setDataSource(is);
            r.readers = new HashMap();
            return r;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setProcessingData(Object data) {
        this.processingData = data;
    }

    public Object getProcessingData() {
        return this.processingData;
    }

    abstract void setDataSource(InputStream var1) throws FileFormatException;

    abstract String getReadersSuffix();

    public Reader getReaderFor(Object o) throws FileFormatException {
        Class<?> c = o.getClass();
        return this.getReaderForClass(c);
    }

    public Reader getSuperReaderFor(Class c) throws FileFormatException {
        Class superC = c.getSuperclass();
        return this.getReaderForClass(superC);
    }

    private Reader getReaderForClass(Class c) throws FileFormatException {
        if (this.readers.get(c) != null) {
            return this.readers.get(c);
        }
        try {
            String rName = c.getPackage().getName() + ".reader." + c.getSimpleName() + this.getReadersSuffix();
            Reader r = (Reader)Class.forName(rName).newInstance();
            r.setReaderFactory(this);
            this.readers.put(c, r);
            return r;
        }
        catch (ClassNotFoundException ex) {
            Class superClass = c.getSuperclass();
            if (superClass != null && !Object.class.equals(superClass)) {
                return this.getReaderForClass(superClass);
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

