/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument.reader;

import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.instrument.CharacterRangeTableAttribute;
import com.sun.tdk.jcov.instrument.reader.Reader;
import com.sun.tdk.jcov.instrument.reader.ReaderFactory;
import com.sun.tdk.jcov.instrument.reader.ReaderFactoryStAX;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class CharacterRangeTableAttributeStAX
implements Reader {
    CharacterRangeTableAttribute crt;
    private XMLStreamReader parser;

    @Override
    public void readData(Object dest) throws FileFormatException {
        this.crt = (CharacterRangeTableAttribute)dest;
        try {
            this.readData();
        }
        catch (XMLStreamException ex) {
            throw new FileFormatException(ex);
        }
    }

    void readData() throws XMLStreamException {
        this.parser.nextTag();
        ArrayList<CharacterRangeTableAttribute.CRTEntry> entriesList = new ArrayList<CharacterRangeTableAttribute.CRTEntry>();
        while (this.parser.getEventType() != 2 || this.parser.getLocalName() != "crt") {
            String elem = this.parser.getLocalName();
            if (elem == "range") {
                int flags = this.getFlags(this.parser);
                int start = Integer.parseInt(this.parser.getAttributeValue(null, "s"));
                int end = Integer.parseInt(this.parser.getAttributeValue(null, "e"));
                this.parser.nextTag();
                int ch_start = this.crt.getPos(Integer.parseInt(this.parser.getAttributeValue(null, "line")), Integer.parseInt(this.parser.getAttributeValue(null, "col")));
                this.parser.nextTag();
                this.parser.nextTag();
                int ch_end = this.crt.getPos(Integer.parseInt(this.parser.getAttributeValue(null, "line")), Integer.parseInt(this.parser.getAttributeValue(null, "col")));
                CharacterRangeTableAttribute.CRTEntry e = new CharacterRangeTableAttribute.CRTEntry(this.crt.getRootId(), start, end, ch_start, ch_end, flags);
                entriesList.add(e);
                this.parser.nextTag();
                this.parser.nextTag();
            }
            this.parser.nextTag();
        }
        this.crt.setEntries(entriesList.toArray(new CharacterRangeTableAttribute.CRTEntry[entriesList.size()]));
    }

    public int getFlags(XMLStreamReader parser) {
        int flags = 0;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String name = parser.getAttributeLocalName(i);
            if (name.equals("statement")) {
                flags |= 1;
                continue;
            }
            if (name.equals("block")) {
                flags |= 2;
                continue;
            }
            if (name.equals("controller")) {
                flags |= 8;
                continue;
            }
            if (name.equals("target")) {
                flags |= 0x10;
                continue;
            }
            if (name.equals("branchtrue")) {
                flags |= 0x80;
                continue;
            }
            if (!name.equals("branchfalse")) continue;
            flags |= 0x100;
        }
        return flags;
    }

    @Override
    public void setReaderFactory(ReaderFactory r) {
        this.parser = ((ReaderFactoryStAX)r).parser;
    }
}

