/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.instrument.InstrumentationParams;
import com.sun.tdk.jcov.util.Utils;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public class StaticInvokeMethodAdapter
extends MethodVisitor {
    static int invokeCount = 0;
    private final String className;
    private final InstrumentationParams params;
    private String methName;
    public static final Map<String, Integer> map = new HashMap<String, Integer>();

    public static int getInvokeID(String owner, String name, String descr) {
        String sig = owner + "." + name + descr;
        Integer id = map.get(sig);
        if (id != null) {
            return id;
        }
        sig = owner + "." + name;
        id = map.get(sig);
        if (id != null) {
            return id;
        }
        return -1;
    }

    public StaticInvokeMethodAdapter(MethodVisitor mv, String className, String methName, int access, InstrumentationParams params) {
        super(458752, mv);
        this.className = className;
        this.params = params;
        this.methName = methName;
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (this.params.isInstrumentFields() && this.params.isIncluded(owner) && this.params.isCallerFilterAccept(this.className) && StaticInvokeMethodAdapter.getInvokeID(owner, name, desc) != -1) {
            int id = StaticInvokeMethodAdapter.getInvokeID(owner, name, desc);
            InsnList il = new InsnList();
            il.add(new LdcInsnNode((Object)id));
            il.add(new MethodInsnNode(184, "com/sun/tdk/jcov/runtime/Collect", "hit", "(I)V"));
            il.accept(this);
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        int id;
        if (((this.params.isInstrumentAbstract() || this.params.isInstrumentNative()) && this.params.isIncluded(owner) || this.params.isCallerFilterAccept(owner)) && StaticInvokeMethodAdapter.getInvokeID(owner, name, desc) != -1) {
            id = StaticInvokeMethodAdapter.getInvokeID(owner, name, desc);
            InsnList il = new InsnList();
            il.add(new LdcInsnNode((Object)id));
            il.add(new MethodInsnNode(184, "com/sun/tdk/jcov/runtime/Collect", "hit", "(I)V", false));
            il.accept(this);
        }
        if (this.params.isCallerFilterOn() && this.params.isCallerFilterAccept(this.className)) {
            id = (name + desc).hashCode();
            super.visitLdcInsn(id);
            super.visitMethodInsn(184, "com/sun/tdk/jcov/runtime/CollectDetect", "setExpected", "(I)V", false);
        }
        if (this.params.isInnerInvacationsOff() && Utils.isAdvanceStaticInstrAllowed(this.className, name) && !owner.equals("java/lang/Object") && this.params.isInnerInstrumentationIncludes(this.className)) {
            id = -1;
            super.visitLdcInsn(id);
            super.visitMethodInsn(184, "com/sun/tdk/jcov/runtime/CollectDetect", "setExpected", "(I)V", false);
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    public void visitInsn(int opcode) {
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                if (!this.params.isInnerInvacationsOff() || !Utils.isAdvanceStaticInstrAllowed(this.className, this.methName)) break;
                if (!this.methName.equals("<clinit>")) {
                    int id = 0;
                    super.visitLdcInsn(id);
                    super.visitMethodInsn(184, "com/sun/tdk/jcov/runtime/CollectDetect", "setExpected", "(I)V");
                    break;
                }
                super.visitMethodInsn(184, "com/sun/tdk/jcov/runtime/CollectDetect", "leaveClinit", "()V");
                break;
            }
        }
        super.visitInsn(opcode);
    }

    public static void addID(String className, String name, String descr, int id) {
        String sig = className + "." + name + descr;
        map.put(sig, id);
    }
}

