/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataBlockTarget;
import com.sun.tdk.jcov.instrument.DataBlockTargetCase;
import com.sun.tdk.jcov.instrument.DataBlockTargetCond;
import com.sun.tdk.jcov.instrument.DataBlockTargetDefault;
import com.sun.tdk.jcov.instrument.DataBlockTargetGoto;
import com.sun.tdk.jcov.instrument.DataExit;
import com.sun.tdk.jcov.instrument.XmlContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class DataBranch
extends DataExit {
    public List<DataBlockTarget> branchTargets;

    DataBranch(int rootId, int bciStart, int bciEnd) {
        super(rootId, bciStart, bciEnd);
        this.branchTargets = new ArrayList<DataBlockTarget>();
    }

    public List<DataBlockTarget> getBranchTargets() {
        return this.branchTargets;
    }

    public void addTarget(DataBlockTarget target) {
        this.branchTargets.add(target);
        target.setEnclosing(this);
    }

    void addBlocks(Collection<DataBlock> collection) {
        for (DataBlock dataBlock : this.branchTargets) {
            collection.add(dataBlock);
        }
    }

    @Override
    void xmlBody(XmlContext ctx) {
        for (DataBlockTarget target : this.branchTargets) {
            if (ctx.showBodiesInExitSubBlocks) {
                target.xmlGen(ctx);
                continue;
            }
            target.xmlGenBodiless(ctx);
        }
    }

    @Override
    public Iterator<DataBlock> getIterator() {
        return new Iterator<DataBlock>(){
            private final Iterator<DataBlockTarget> delegate;
            {
                this.delegate = DataBranch.this.branchTargets.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public DataBlock next() {
                return this.delegate.next();
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    void printDebug(PrintStream out, String indent) {
        super.printDebug(out, indent);
        String newIndent = indent + "    ";
        for (DataBlockTarget target : this.branchTargets) {
            target.printDebug(out, newIndent);
        }
    }

    @Override
    void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeShort(this.branchTargets.size());
        for (DataBlockTarget t : this.branchTargets) {
            if (t instanceof DataBlockTargetCase) {
                out.write(1);
            } else if (t instanceof DataBlockTargetCond) {
                out.write(2);
            } else if (t instanceof DataBlockTargetDefault) {
                out.write(3);
            } else if (t instanceof DataBlockTargetGoto) {
                out.write(4);
            } else {
                throw new IOException("DataBranch.writeObject: Unknown dataBlockTarget class " + t.getClass().getName() + ".");
            }
            t.writeObject(out);
        }
    }

    DataBranch(int rootId, DataInput in) throws IOException {
        super(rootId, in);
        int size = in.readShort();
        this.branchTargets = new ArrayList<DataBlockTarget>(size);
        block6: for (int i = 0; i < size; ++i) {
            byte code = in.readByte();
            switch (code) {
                case 1: {
                    this.branchTargets.add(new DataBlockTargetCase(rootId, in));
                    continue block6;
                }
                case 2: {
                    this.branchTargets.add(new DataBlockTargetCond(rootId, in));
                    continue block6;
                }
                case 3: {
                    this.branchTargets.add(new DataBlockTargetDefault(rootId, in));
                    continue block6;
                }
                case 4: {
                    this.branchTargets.add(new DataBlockTargetGoto(rootId, in));
                    continue block6;
                }
                default: {
                    throw new IOException("DataBlockTarget with unknown code in DataBranch " + code);
                }
            }
        }
    }
}

