/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataBlockCatch;
import com.sun.tdk.jcov.instrument.DataBlockFallThrough;
import com.sun.tdk.jcov.instrument.DataBlockMethEnter;
import com.sun.tdk.jcov.instrument.DataBlockTarget;
import com.sun.tdk.jcov.instrument.DataBranch;
import com.sun.tdk.jcov.instrument.DataBranchCond;
import com.sun.tdk.jcov.instrument.DataBranchGoto;
import com.sun.tdk.jcov.instrument.DataBranchSwitch;
import com.sun.tdk.jcov.instrument.DataExit;
import com.sun.tdk.jcov.instrument.DataExitSimple;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.LocationConcrete;
import com.sun.tdk.jcov.instrument.MergeException;
import com.sun.tdk.jcov.instrument.XmlContext;
import com.sun.tdk.jcov.tools.DelegateIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.LabelNode;

public class BasicBlock
extends LocationConcrete {
    private DataBlock fallenInto = null;
    public final Map<DataBlock, LabelNode> blockMap;
    public DataExit exit = null;

    BasicBlock(int rootId, int startBCI) {
        super(rootId, startBCI);
        this.blockMap = new IdentityHashMap<DataBlock, LabelNode>();
    }

    BasicBlock(int rootId, int startBCI, int endBCI) {
        super(rootId, startBCI, endBCI);
        this.blockMap = new IdentityHashMap<DataBlock, LabelNode>();
    }

    public BasicBlock(int rootId) {
        this(rootId, -1);
    }

    void add(DataBlock blk, LabelNode label) {
        this.blockMap.put(blk, label);
        if (blk.isFallenInto()) {
            this.fallenInto = blk;
        }
        blk.setConcreteLocation(this);
    }

    public void add(DataBlock blk) {
        this.add(blk, null);
    }

    LabelNode getLabel(DataBlock blk) {
        return this.blockMap.get(blk);
    }

    boolean contains(DataBlock blk) {
        return this.blockMap.containsKey(blk);
    }

    DataBlock fallenInto() {
        return this.fallenInto;
    }

    public void setExit(DataExit exit) {
        this.exit = exit;
    }

    Collection<DataBlock> blocks() {
        return this.blockMap.keySet();
    }

    Set<Map.Entry<DataBlock, LabelNode>> blockLabelSet() {
        return this.blockMap.entrySet();
    }

    boolean wasHit() {
        return this.fallenInto() == null ? false : this.fallenInto().wasHit();
    }

    @Override
    public String kind() {
        return "bl";
    }

    @Override
    void xmlBody(XmlContext ctx) {
        this.xmlDetailBody(ctx);
    }

    void xmlDetailBody(XmlContext ctx) {
        if (ctx.showNonNested && this.blockMap != null) {
            for (DataBlock block : this.blockMap.keySet()) {
                if (block.isNested()) continue;
                block.xmlGen(ctx);
            }
        }
        if (this.exit != null) {
            this.exit.xmlGen(ctx);
        }
    }

    public void checkCompatibility(BasicBlock other) throws MergeException {
        if (this.blockMap.keySet().size() != other.blocks().size()) {
            throw new MergeException("Block has other number of data blocks than it's merging copy, expected " + this.blockMap.keySet().size() + "; found " + other.blocks().size(), "", 1);
        }
        if (this.exit instanceof DataBranch) {
            if (!(other.exit instanceof DataBranch)) {
                throw new MergeException("Block exit has other type than it's merging copy, expected DataBranchAbstract; found " + other.exit, "", 1);
            }
            DataBranch branch = (DataBranch)this.exit;
            DataBranch obranch = (DataBranch)other.exit;
            if (branch.branchTargets.size() != obranch.branchTargets.size()) {
                throw new MergeException("Block has other number of data blocks (targets) than it's merging copy, expected " + this.blockMap.keySet().size() + "; found " + other.blocks().size(), "", 1);
            }
        }
    }

    public void merge(BasicBlock other) {
        boolean dynamicCollected = DataRoot.getInstance(this.rootId).getParams().isDynamicCollect() || DataRoot.getInstance(other.rootId).getParams().isDynamicCollect();
        BasicBlock.mergeDataBlocks(this.blockMap.keySet(), other.blocks(), dynamicCollected);
        if (this.exit instanceof DataBranch) {
            DataBranch branch = (DataBranch)this.exit;
            DataBranch obranch = (DataBranch)other.exit;
            BasicBlock.mergeDataBlocks(branch.branchTargets, obranch.branchTargets, dynamicCollected);
        }
    }

    private static void mergeDataBlocks(Collection<? extends DataBlock> blocks, Collection<? extends DataBlock> oblocks, boolean dynamicCollected) {
        block0: for (DataBlock dataBlock : blocks) {
            for (DataBlock dataBlock2 : oblocks) {
                if (dynamicCollected) {
                    if (dataBlock.startBCI() != dataBlock2.startBCI() || dataBlock.endBCI() != dataBlock2.endBCI() || dataBlock.getClass() != dataBlock2.getClass() || dataBlock.isFallenInto() != dataBlock2.isFallenInto()) continue;
                    dataBlock.mergeScale(dataBlock2);
                    dataBlock.setCount(dataBlock.getCount() + dataBlock2.getCount());
                    continue block0;
                }
                if (dataBlock.getId() != dataBlock2.getId()) continue;
                dataBlock.mergeScale(dataBlock2);
                dataBlock.setCount(dataBlock.getCount() + dataBlock2.getCount());
                continue block0;
            }
        }
    }

    public Iterator<DataBlock> getIterator() {
        return new DelegateIterator<DataBlock>(){
            private int index;

            @Override
            protected Iterator<DataBlock> nextIterator() {
                if (this.index == 0) {
                    ++this.index;
                    return BasicBlock.this.blockMap.keySet().iterator();
                }
                if (this.index == 1) {
                    ++this.index;
                    if (BasicBlock.this.exit != null) {
                        return BasicBlock.this.exit.getIterator();
                    }
                    return this.nextIterator();
                }
                return null;
            }
        };
    }

    @Override
    void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        Collection<DataBlock> blocks = this.blocks();
        int blocksNum = 0;
        for (DataBlock b : blocks) {
            if (b instanceof DataBlockTarget) continue;
            ++blocksNum;
        }
        out.writeShort(blocksNum);
        for (DataBlock b : blocks) {
            if (b instanceof DataBlockTarget) continue;
            if (b instanceof DataBlockCatch) {
                out.write(0);
            } else if (b instanceof DataBlockFallThrough) {
                out.write(1);
            } else if (b instanceof DataBlockMethEnter) {
                out.write(2);
            } else {
                throw new IOException("BasicBlock.writeObject - Unknown dataBlock class " + b.getClass().getName() + ".");
            }
            b.writeObject(out);
        }
        if (this.exit != null) {
            out.writeBoolean(true);
            if (this.exit instanceof DataExitSimple) {
                out.write(1);
            } else if (this.exit instanceof DataBranchCond) {
                out.write(2);
            } else if (this.exit instanceof DataBranchGoto) {
                out.write(3);
            } else if (this.exit instanceof DataBranchSwitch) {
                out.write(4);
            } else {
                throw new IOException("BasicBlock.writeObject - Unknown dataExit class " + this.exit.getClass().getName() + ". Please contact jcov_dev_ww@oracle.com");
            }
            this.exit.writeObject(out);
        } else {
            out.writeBoolean(false);
        }
    }

    BasicBlock(int rootId, DataInput in) throws IOException {
        super(rootId, in);
        byte code;
        int blockNum = in.readShort();
        this.blockMap = new IdentityHashMap<DataBlock, LabelNode>(blockNum);
        block11: for (int i = 0; i < blockNum; ++i) {
            code = in.readByte();
            switch (code) {
                case 0: {
                    this.blockMap.put(new DataBlockCatch(rootId, in), null);
                    continue block11;
                }
                case 1: {
                    this.blockMap.put(new DataBlockFallThrough(rootId, in), null);
                    continue block11;
                }
                case 2: {
                    this.blockMap.put(new DataBlockMethEnter(rootId, in), null);
                    continue block11;
                }
                default: {
                    throw new IOException("DataBlock with unknown code in BasicBlock " + code);
                }
            }
        }
        if (in.readBoolean()) {
            code = in.readByte();
            switch (code) {
                case 1: {
                    this.exit = new DataExitSimple(rootId, in);
                    break;
                }
                case 2: {
                    this.exit = new DataBranchCond(rootId, in);
                    break;
                }
                case 3: {
                    this.exit = new DataBranchGoto(rootId, in);
                    break;
                }
                case 4: {
                    this.exit = new DataBranchSwitch(rootId, in);
                    break;
                }
                default: {
                    throw new IOException("DataExit with unknown code in BasicBlock " + code);
                }
            }
        }
    }
}

