/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.ant;

import com.sun.tdk.jcov.Instr;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.runtime.PropertyFinder;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.resources.FileResource;

public class Instrument
extends Task {
    private File destdir;
    private File productDir;
    private List<BinPath> implantTo = new LinkedList<BinPath>();
    private List<FileSet> files = new LinkedList<FileSet>();
    private PatternSet filter;
    private LinkedList<SavePoint> saveBegin = new LinkedList();
    private LinkedList<SavePoint> saveEnd = new LinkedList();
    private boolean verbose;
    private File template;
    private File outtemplate;
    private boolean showabstract = false;
    private boolean shownative = false;
    private boolean showfields = false;
    public File propfile = null;
    String[] incl;
    String[] excl;

    public void execute() throws BuildException {
        File oldBase = null;
        if (this.propfile != null) {
            PropertyFinder.setPropertiesFile(this.propfile.getPath());
        }
        if (this.destdir != null) {
            if (this.destdir.exists() && !this.destdir.isDirectory()) {
                throw new BuildException("Output path is a file");
            }
            if (this.productDir != null) {
                if (!this.productDir.exists()) {
                    throw new BuildException("Project directory + " + this.productDir + " doesn't exist");
                }
                if (!this.productDir.isDirectory()) {
                    throw new BuildException("Project path " + this.productDir + " is not a directory");
                }
                if (!this.destdir.exists()) {
                    throw new BuildException("Output directory " + this.destdir + " doesn't exist");
                }
                this.copyProduct();
                this.log("Product mode: working in " + this.destdir + "...", 3);
                oldBase = this.convertPaths();
            }
        } else if (this.productDir != null) {
            throw new BuildException("Destdir needed in project mode");
        }
        Object[] paths = this.getUniquePaths();
        if (this.implantTo.isEmpty() && paths.length < 1) {
            this.log("Warning: no binaries found to instrument", 2);
        }
        this.log("Creating instrumentator", 4);
        Instr instr = new Instr();
        this.log("Reseting instrumentator to defaults", 3);
        instr.resetDefaults();
        this.log("Configuring insturumentator", 4);
        this.applyFilter(this.filter, instr);
        if (this.template != null) {
            instr.setTemplate(this.template.getPath());
        } else {
            instr.setTemplate("template.xml");
        }
        instr.setVerbose(this.verbose);
        Object[] saveBeg = null;
        int size = this.saveBegin.size();
        int i = 0;
        if (size > 0) {
            saveBeg = new String[size];
            i = 0;
            for (SavePoint savePoint : this.saveBegin) {
                saveBeg[i] = savePoint.name;
            }
        }
        Object[] saveE = null;
        size = this.saveEnd.size();
        if (size > 0) {
            saveE = new String[size];
            i = 0;
            for (SavePoint savePoint : this.saveEnd) {
                saveE[i] = savePoint.name;
            }
        }
        String string = this.showabstract ? "on" : "off";
        this.showabstract = "on".equals(PropertyFinder.findValue(InstrumentationOptions.DSC_ABSTRACT.name, string));
        String string2 = this.showfields ? "on" : "off";
        this.showfields = "on".equals(PropertyFinder.findValue(InstrumentationOptions.DSC_FIELD.name, string2));
        String string3 = this.shownative ? "on" : "off";
        this.shownative = "on".equals(PropertyFinder.findValue(InstrumentationOptions.DSC_NATIVE.name, string3));
        instr.config(this.showabstract, this.showfields, this.shownative, (String[])saveBeg, (String[])saveE);
        this.log("Insturumentator configured", 4);
        try {
            instr.startWorking();
            this.log("Instrumentation started", 4);
            this.log(String.format("Parameters: filter incl %s excl %s; template %s; outtemplate %s; save_beg %s save_end %s; abstract %s fields %s native %s", Arrays.toString(this.incl), Arrays.toString(this.excl), this.template, this.outtemplate, Arrays.toString(saveBeg), Arrays.toString(saveE), this.showabstract, this.showfields, this.shownative), 3);
            for (BinPath path : this.implantTo) {
                File output;
                File file = output = this.productDir == null ? this.destdir : null;
                if (path.implantRT == null) {
                    this.log("Implanting runtime file was not found for binary " + path.path + ". Please use <files> if you want to instrument single file without implanting runtime binaries.", 2);
                    throw new BuildException("Cannot implant runtime data");
                }
                this.log(path.getInstrumentingLog(output), 2);
                instr.instrumentFile(path.path.getPath(), output, path.implantRT.getPath());
            }
            this.log("<implantTo> instrumentation complete", 4);
            if (paths != null && paths.length > 0) {
                File file = this.productDir == null ? this.destdir : null;
                this.log("Instrumenting paths " + Arrays.toString(paths), 3);
                for (FileSet fs : this.files) {
                    File root = fs.getDir();
                    for (FileResource file2 : fs) {
                        if (this.implantToContains(file2.getFile())) continue;
                        instr.instrumentFile(root.getPath() + File.separator + file2.getName(), new File(file, file2.getName()), null);
                    }
                }
            }
            this.log("<files> instrumentation complete", 4);
            if (this.productDir != null) {
                this.log("Resetting basedir", 3);
                this.getProject().setBaseDir(oldBase);
            }
            if (this.outtemplate != null) {
                this.log("Writing result template to " + this.outtemplate, 2);
                instr.finishWork(this.outtemplate.getPath());
            } else {
                this.log("Writing result template to template.xml", 2);
                instr.finishWork();
            }
            this.log("Instrumentation finished", 3);
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (Exception exception) {
            this.log("Instrumentation task failed: ", exception, 1);
            exception.printStackTrace();
            throw new BuildException("Instrumentation task failed: " + exception.getMessage(), (Throwable)exception);
        }
        if (this.propfile != null) {
            PropertyFinder.cleanProperties();
        }
    }

    private void copyProduct() {
        Copy copy = new Copy();
        copy.setProject(this.getProject());
        copy.setTaskName("instrument");
        FileSet fileSet = new FileSet();
        fileSet.setDir(this.productDir);
        copy.addFileset(fileSet);
        copy.setTodir(this.destdir);
        copy.perform();
    }

    private File convertPaths() {
        File oldBase = this.getProject().getBaseDir();
        this.getProject().setBaseDir(this.productDir);
        String proj = this.destdir.getPath();
        if (this.files != null) {
            for (FileSet fs : this.files) {
                fs.setDir(new File(proj + fs.getDir().getPath().substring(oldBase.getPath().length())));
            }
        }
        return oldBase;
    }

    public void setVerbose(Boolean verbose) throws Exception {
        this.verbose = verbose;
    }

    public void setTemplate(File template) {
        if (!template.exists()) {
            throw new BuildException("Template " + template + " doesn't exist");
        }
        if (!template.isFile()) {
            throw new BuildException("Template " + template + " is not a file");
        }
        this.template = template;
    }

    public void setOutTemplate(File outtemplate) {
        if (outtemplate.exists()) {
            if (outtemplate.isDirectory()) {
                this.outtemplate = new File(outtemplate, "template.xml");
                this.log("Warning, path for template " + outtemplate + " is directory, writing to " + this.outtemplate, 3);
                return;
            }
            throw new BuildException("Template " + outtemplate + " exist");
        }
        this.outtemplate = outtemplate;
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void setProductDir(File project) {
        this.productDir = project;
    }

    public PatternSet createFilter() throws Exception {
        if (this.filter != null) {
            throw new Exception("filter should be only one");
        }
        this.filter = new PatternSet();
        return this.filter;
    }

    public SavePoint createSaveBegin() throws Exception {
        SavePoint sp = new SavePoint();
        this.saveBegin.add(sp);
        return sp;
    }

    public SavePoint createSaveEnd() throws Exception {
        SavePoint sp = new SavePoint();
        this.saveEnd.add(sp);
        return sp;
    }

    public BinPath createImplantTo() {
        BinPath path = new BinPath();
        this.implantTo.add(path);
        return path;
    }

    public FileSet createFiles() {
        FileSet fs = new FileSet();
        this.files.add(fs);
        return fs;
    }

    private String[] getUniquePaths() {
        if (this.files == null || this.files.isEmpty()) {
            return null;
        }
        HashSet<String> pathsSet = new HashSet<String>();
        for (FileSet fs : this.files) {
            fs.getDir();
            for (Object o : fs) {
                FileResource fr;
                File file;
                if (!(o instanceof FileResource) || this.implantToContains(file = (fr = (FileResource)o).getFile())) continue;
                pathsSet.add(file.getPath());
            }
        }
        return pathsSet.toArray(new String[pathsSet.size()]);
    }

    private boolean implantToContains(File file) {
        for (BinPath bp : this.implantTo) {
            if (!bp.path.equals(file)) continue;
            return true;
        }
        return false;
    }

    private void applyFilter(PatternSet filter, Instr instr) {
        this.incl = instr.getInclude();
        this.excl = instr.getExclude();
        if (filter != null) {
            this.incl = filter.getIncludePatterns(this.getProject());
            this.excl = filter.getExcludePatterns(this.getProject());
            instr.setFilter(this.incl, this.excl);
        }
    }

    public void setNative(boolean shownative) {
        this.shownative = shownative;
    }

    public void setFields(boolean showfields) {
        this.showfields = showfields;
    }

    public void setAbstract(boolean showabstract) {
        this.showabstract = showabstract;
    }

    public void setPropfile(File path) {
        this.propfile = path;
    }

    public static class SavePoint {
        private String name;

        public void setName(String name) {
            this.name = name;
        }
    }

    public class BinPath {
        protected File path;
        protected File implantRT;

        public void setPath(File path) throws Exception {
            if (Instrument.this.destdir != null && Instrument.this.productDir != null) {
                String proj = Instrument.this.destdir.getPath();
                path = new File(proj + path.getPath().substring(Instrument.this.getProject().getBaseDir().getPath().length()));
            } else if (!path.exists()) {
                throw new BuildException("Binary root " + path + " doesn't exist");
            }
            this.path = path;
        }

        public void setImplantRT(File implantRT) {
            if (!implantRT.exists()) {
                throw new BuildException("Runtime file " + implantRT + " doesn't exist");
            }
            if (!implantRT.isFile() || !implantRT.getName().endsWith("jar")) {
                throw new BuildException("Runtime file " + implantRT + " is not a jar file");
            }
            this.implantRT = implantRT;
        }

        public String getInstrumentingLog(File output) {
            if (output != null) {
                return String.format("Instrumenting classfiles dir %s to %s with implanted %s", this.path.getPath(), output, this.implantRT);
            }
            return String.format("Instrumenting classfiles dir %s with implanted %s", this.path.getPath(), this.implantRT);
        }
    }
}

