/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov;

import com.sun.tdk.jcov.Client;
import com.sun.tdk.jcov.Grabber;
import com.sun.tdk.jcov.Merger;
import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.data.Result;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.instrument.DataPackage;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.runtime.Collect;
import com.sun.tdk.jcov.runtime.FileSaver;
import com.sun.tdk.jcov.tools.LoggingFormatter;
import com.sun.tdk.jcov.util.RuntimeUtils;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;

class Server
extends Thread {
    private String fileName;
    private final String templateName;
    private final int port;
    private int saveCount;
    private boolean saveAtReceive;
    private final String hostName;
    private final boolean once;
    private String outTestList;
    private boolean genscale;
    private String saveBadData;
    private boolean working = true;
    private boolean listening = true;
    private boolean dataSaved = false;
    private boolean started = false;
    private ServerSocket ss = null;
    private long[] data = null;
    private DataRoot dataRoot = null;
    private int totalConnections;
    int aliveClients = 0;
    private LinkedList<String> tests;
    static int MAX_TIMEOUT = 90000;
    static boolean showMemoryChecks = false;
    static final Runtime rt = Runtime.getRuntime();
    private long reservedMemory = 0L;
    private int dumpCount = 0;
    private boolean dumping = false;
    static final Object STOP_THE_WORLD_LOCK = new Object();
    private boolean veryLowMemoryRun = false;
    private boolean lowMemoryRun = false;
    private boolean normalMemoryRun = false;
    private boolean mergeByTestNames = false;
    private ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());

    public Server(int port, boolean once, String template, String host, boolean saveAtRecieve, boolean genscale, boolean mergeByTestNames) throws BindException, IOException {
        this.setName("ServerThread");
        this.setDaemon(false);
        this.totalConnections = 0;
        this.once = once;
        this.templateName = template;
        this.hostName = host;
        this.saveAtReceive = saveAtRecieve;
        this.genscale = genscale;
        this.mergeByTestNames = mergeByTestNames;
        if (this.genscale) {
            this.tests = new LinkedList();
        }
        if (this.once) {
            this.port = port;
            if (this.port == 0) {
                throw new IllegalArgumentException("Port should be specified in 'once' mode");
            }
        } else {
            try {
                this.initDataRoot();
                if (genscale) {
                    rt.gc();
                    if ((double)rt.totalMemory() > (double)rt.maxMemory() / 1.2) {
                        Grabber.logger.log(Level.WARNING, "Server started with very low memory: it''s recomended at least {0}M max memory for this template. Server will not write data dumps on low memory and can fail in OutOfMemoryError.", rt.totalMemory() * 3L / 1000000L);
                        this.veryLowMemoryRun = true;
                    } else if ((double)rt.totalMemory() > (double)rt.maxMemory() / 2.5) {
                        if (showMemoryChecks) {
                            Grabber.logger.log(Level.WARNING, "Server started with low memory: it''s recomended at least {0}M max memory for this template. Server will write data dumps on low memory and will try to merge them on exit.", (double)rt.totalMemory() * 2.5 / 1000000.0);
                        }
                        this.lowMemoryRun = true;
                    } else {
                        if (showMemoryChecks) {
                            Grabber.logger.log(Level.INFO, "Server will write data dumps on 45% free memory and will try to merge them on exit.");
                        }
                        this.normalMemoryRun = true;
                    }
                }
            }
            catch (FileFormatException ex) {
                throw new IllegalArgumentException("Bad template: " + this.templateName, ex);
            }
            this.ss = new ServerSocket(port);
            this.port = this.ss.getLocalPort();
        }
    }

    Server(int port, boolean once, String template, String output, String outTestList, String host, int maxCount, boolean saveAtReceive, boolean genscale, boolean mergeByTestNames) throws BindException, IOException {
        this(port, once, template, host, saveAtReceive, genscale || outTestList != null, mergeByTestNames);
        this.fileName = output;
        this.outTestList = outTestList;
        this.saveCount = maxCount;
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.once) {
            this.started = true;
            try {
                InetAddress adr = this.hostName == null ? InetAddress.getLocalHost() : InetAddress.getByName(this.hostName);
                Socket s = new Socket(adr, this.port);
                Grabber.logger.log(Level.INFO, "Connection established with {0}:{1}", new Object[]{adr, this.port});
                ++this.aliveClients;
                new Client(this, s, 0).executeClient();
                this.saveData();
                Grabber.logger.log(Level.FINE, "Server stopped");
            }
            catch (Exception e) {
                Grabber.logger.log(Level.SEVERE, "Jcov grabber failed", e);
            }
            finally {
                this.working = false;
            }
        } else {
            this.started = true;
            try {
                int n = 0;
                do {
                    Grabber.logger.log(Level.FINE, "Waiting for new connection");
                    Socket s = this.ss.accept();
                    Client c = new Client(this, s, ++n);
                    Grabber.logger.log(Level.INFO, "Connection N{0} received from {1}:{2}", new Object[]{n + "", s.getInetAddress(), s.getLocalPort() + ""});
                    Grabber.logger.log(Level.FINE, "Alive connections: {0}; total connections: {1}", new Object[]{this.aliveClients + 1 + "", this.totalConnections + 1 + ""});
                    ++this.aliveClients;
                    this.executor.execute(c);
                    ++this.totalConnections;
                } while (--this.saveCount != 0 && this.listening);
                if (this.saveCount == 0 && this.listening) {
                    this.kill(false);
                }
            }
            catch (Throwable e) {
                if (this.listening) {
                    LoggingFormatter.printStackTrace = true;
                    Grabber.logger.log(Level.SEVERE, "JCov grabber failed", e);
                    this.working = false;
                }
            }
            finally {
                int timeout = 0;
                while (this.working && timeout < MAX_TIMEOUT * 2) {
                    try {
                        Thread.sleep(500L);
                        timeout += 500;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.ss = null;
                this.working = false;
                this.listening = false;
                Grabber.logger.log(Level.FINE, "Server stopped");
            }
        }
    }

    public void kill(boolean force) {
        this.listening = false;
        if (this.ss != null && !this.ss.isClosed()) {
            try {
                this.ss.close();
            }
            catch (Exception ex) {
                Grabber.logger.log(Level.SEVERE, "Error while closing socket", ex);
            }
        }
        if (!force && this.clientsAlive()) {
            Grabber.logger.log(Level.INFO, "Awaiting for finishing data transmission from {0} clients. Max timeout time: {1}ms", new Object[]{this.getAliveConnectionCount() + "", MAX_TIMEOUT});
            this.waitForAliveClients();
        }
        if (!force && !this.dataSaved) {
            this.saveData();
            if (this.dataRoot != null) {
                this.dataRoot.destroy();
            }
            if (this.dumpCount > 0 && !this.veryLowMemoryRun) {
                Grabber.logger.log(Level.WARNING, "Server is merging dumped data: {0} files should be merged", this.dumpCount + "");
                Merger merger = new Merger();
                Result[] res = new Result[this.dumpCount + 1];
                try {
                    res[0] = new Result(this.fileName, this.outTestList);
                    for (int i = 0; i < this.dumpCount; ++i) {
                        if (this.outTestList == null) continue;
                        res[i + 1] = new Result(this.fileName, this.outTestList + i);
                    }
                }
                catch (IOException i) {
                    // empty catch block
                }
                System.out.println("Server.this.templateName = " + this.templateName);
                Merger.Merge m = new Merger.Merge(res, this.templateName);
                try {
                    merger.mergeAndWrite(m, this.outTestList, this.fileName, null);
                }
                catch (OutOfMemoryError e) {
                    Grabber.logger.log(Level.SEVERE, "OutOfMemoryError while merging dumped files. Please merge them manually: 'java -jar jcov.jar merger -o {0} -outTestList {1} {0}%{1} {0}0%{1}) {0}1%{1}1 ...'.", new Object[]{this.fileName, this.outTestList});
                }
                catch (Throwable e) {
                    // empty catch block
                }
                for (int i = 0; i < this.dumpCount; ++i) {
                    new File(this.fileName + this.dumpCount).delete();
                    new File(this.outTestList + this.dumpCount).delete();
                }
                Grabber.logger.log(Level.INFO, "Merging done");
            }
        }
        this.executor.shutdown();
        this.working = false;
    }

    private void initDataRoot() throws FileFormatException {
        if (this.templateName != null) {
            Grabber.logger.log(Level.FINE, "Server is reading template {0}", this.templateName);
            this.dataRoot = DataRoot.read(this.templateName, false, null);
            this.dataRoot.makeAttached();
            Collect.SLOTS = this.dataRoot.getCount();
            Collect.enableCounts();
            this.data = Collect.counts();
            if (this.genscale) {
                this.dataRoot.getScaleOpts().setReadScales(true);
                if (this.outTestList != null) {
                    this.dataRoot.getScaleOpts().setOutTestList(this.outTestList);
                }
                this.dataRoot.cleanScales();
            }
            Grabber.logger.log(Level.FINER, "Server finished reading template", this.templateName);
        }
    }

    public synchronized void handleData(long[] data, Client client) {
        if (!this.working) {
            return;
        }
        if (this.templateName == null) {
            Grabber.logger.log(Level.SEVERE, "Server can't accept static data - started without template");
            return;
        }
        this.dataSaved = false;
        Grabber.logger.log(Level.INFO, "Server got data from client N{0}", client.getClientNumber() + "");
        if (this.saveAtReceive) {
            Grabber.logger.log(Level.FINE, "Server is saving data from client N{0}", client.getClientNumber() + "");
            for (int i = 0; i < data.length && i < this.dataRoot.getCount(); ++i) {
                int n = i;
                this.data[n] = this.data[n] + data[i];
            }
            this.saveData(data);
        } else {
            if (this.data == null) {
                this.data = Collect.counts();
            }
            for (int i = 0; i < data.length && i < this.dataRoot.getCount(); ++i) {
                int n = i;
                this.data[n] = this.data[n] + data[i];
            }
            if (this.genscale) {
                this.dataRoot.addScales();
                this.dataRoot.update();
                boolean merged = false;
                if (this.mergeByTestNames) {
                    for (int i = 0; i < this.tests.size(); ++i) {
                        if (!this.tests.get(i).equals(client.getTestName())) continue;
                        ArrayList<Utils.Pair> list = new ArrayList<Utils.Pair>();
                        list.add(new Utils.Pair(i, this.tests.size()));
                        this.dataRoot.illuminateDuplicatesInScales(list);
                        merged = true;
                        break;
                    }
                }
                if (!merged) {
                    this.tests.add(client.getTestName());
                }
            }
        }
        Grabber.logger.log(Level.FINEST, "Data from client N{0} saved", client.getClientNumber() + "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void handleData(DataRoot root, Client client) {
        boolean merged = false;
        try {
            if (!this.working) {
                return;
            }
            this.dataSaved = false;
            Grabber.logger.log(Level.FINER, "Server got dynamic data from client N{0}", client.getClientNumber() + "");
            if (this.saveAtReceive) {
                try {
                    root.write(this.fileName, InstrumentationOptions.MERGE.MERGE);
                }
                catch (Exception ex) {
                    Grabber.logger.log(Level.SEVERE, "Server can't save data from client N{0} to file '{1}' on recieve: {2}", new Object[]{client.getClientNumber() + "", this.fileName, ex.getMessage()});
                }
            } else {
                Grabber.logger.log(Level.FINE, "Server is merging dynamic data from client N{0}", client.getClientNumber() + "");
                root.getScaleOpts().setScaleSize(root.getScaleOpts().getScaleSize() + 1);
                if (this.templateName == null && this.dataRoot == null) {
                    this.dataRoot = root;
                    this.dataRoot.attach();
                    if (this.genscale && (this.dataRoot.getScaleOpts() == null || !this.dataRoot.getScaleOpts().needReadScales())) {
                        this.dataRoot.getScaleOpts().setReadScales(true);
                        this.dataRoot.getScaleOpts().setOutTestList(this.outTestList);
                        this.dataRoot.getScaleOpts().setScaleSize(1);
                        this.tests.add(client.getTestName());
                    }
                } else {
                    int severity = 0;
                    if (this.templateName != null) {
                        severity = 3;
                    }
                    DataRoot.CompatibilityCheckResult cc = this.dataRoot.checkCompatibility(root, severity, true);
                    if (cc.errors == 0) {
                        if (this.genscale && this.mergeByTestNames) {
                            for (int i = 0; i < this.tests.size(); ++i) {
                                if (!this.tests.get(i).equals(client.getTestName())) continue;
                                this.dataRoot.merge(root, this.templateName == null);
                                ArrayList<Utils.Pair> list = new ArrayList<Utils.Pair>();
                                list.add(new Utils.Pair(i, this.tests.size()));
                                this.dataRoot.illuminateDuplicatesInScales(list);
                                merged = true;
                                break;
                            }
                        }
                        if (this.genscale && !merged) {
                            this.dataRoot.merge(root, this.templateName == null);
                            this.tests.add(client.getTestName());
                            merged = true;
                        }
                        if (!this.genscale) {
                            this.dataRoot.merge(root, this.templateName == null);
                            merged = true;
                        }
                        Grabber.logger.log(Level.FINER, "Server finished merging dynamic data from client N{0}", client.getClientNumber() + "");
                    } else if (this.saveBadData != null) {
                        String filename = this.saveBadData + "_" + client.getTestName() + ".xml";
                        Grabber.logger.log(Level.INFO, "Malformed data from client N{0}: saving data to '{1}'", new Object[]{client.getClientNumber() + "", filename});
                        try {
                            root.write(filename, InstrumentationOptions.MERGE.GEN_SUFF);
                        }
                        catch (Exception ex) {
                            Grabber.logger.log(Level.SEVERE, "Can't save malformed data from client N{0} to file '{1}': {2}", new Object[]{client.getClientNumber() + "", filename, ex.getMessage()});
                        }
                    } else {
                        Grabber.logger.log(Level.SEVERE, "Malformed data from client N{0}: not saving", client.getClientNumber() + "");
                    }
                }
            }
        }
        finally {
            if (this.dataRoot != root && !merged) {
                root.destroy();
            }
        }
    }

    public synchronized void saveData() {
        if (this.dataSaved) {
            Grabber.logger.log(Level.FINE, "No new data received - nothing to save");
            return;
        }
        Grabber.logger.log(Level.INFO, "Server is saving cached data to {0}", this.fileName);
        this.saveData(this.data);
        Grabber.logger.log(Level.FINE, "Saving done");
    }

    private synchronized void saveData(long[] data) {
        try {
            Object file;
            if (!this.saveAtReceive && ((File)(file = new File(this.fileName))).exists() && !((File)file).delete()) {
                File nfile = Server.getUnexistingFile((File)file);
                Grabber.logger.log(Level.SEVERE, "Error: given file '{0}' exists, cannot overwrite it. Data saved to '{1}'", new Object[]{((File)file).getPath(), nfile.getPath()});
                file = nfile;
                this.fileName = nfile.getPath();
            }
            if (this.dataRoot != null) {
                if (this.templateName != null) {
                    this.dataRoot.update();
                    if (this.dataRoot.getParams().isInstrumentAbstract() || this.dataRoot.getParams().isInstrumentNative()) {
                        for (DataPackage dp : this.dataRoot.getPackages()) {
                            for (DataClass dc : dp.getClasses()) {
                                for (DataMethod dm : dc.getMethods()) {
                                    if (!dm.isAbstract() && (dm.getAccess() & 0x100) == 0 || data.length <= dm.getSlot() || dm.getCount() >= data[dm.getSlot()]) continue;
                                    dm.setCount(data[dm.getSlot()]);
                                }
                            }
                        }
                    }
                }
                FileSaver fs = FileSaver.getFileSaver(this.dataRoot, this.fileName, this.templateName, InstrumentationOptions.MERGE.OVERWRITE, false, true);
                fs.saveResults(this.fileName);
            } else if (this.templateName != null) {
                Utils.copyFile(new File(this.templateName), new File(this.fileName));
            }
            if (this.outTestList != null) {
                Utils.writeLines(this.outTestList, this.tests.toArray(new String[this.tests.size()]));
            }
            this.dataSaved = true;
        }
        catch (Exception ex) {
            Grabber.logger.log(Level.SEVERE, "Error while saving data", ex);
        }
    }

    void increaseReserved(long reserve) {
        this.reservedMemory += reserve;
    }

    void decreaseReserved(long reserve) {
        this.reservedMemory -= reserve;
    }

    synchronized boolean checkFreeMemory(long minMemory) throws Exception {
        if (this.genscale) {
            long mem = rt.freeMemory() + (rt.maxMemory() - rt.totalMemory());
            if (showMemoryChecks) {
                Grabber.logger.log(Level.FINER, "Memory check routine. Total: {0}; max: {1}; free: {2}; max-total {3}", new Object[]{rt.totalMemory(), rt.maxMemory(), rt.freeMemory(), rt.maxMemory() - rt.totalMemory()});
            }
            if ((this.veryLowMemoryRun || this.lowMemoryRun) && mem < minMemory || this.normalMemoryRun && rt.totalMemory() - rt.freeMemory() > rt.maxMemory() / 3L) {
                Grabber.logger.log(Level.INFO, "Server is at low memory: trying to clean memory...");
                rt.gc();
                Thread.yield();
                mem = rt.freeMemory() + (rt.maxMemory() - rt.totalMemory());
                if (this.lowMemoryRun && mem < minMemory && !this.dumping || this.normalMemoryRun && (double)(rt.totalMemory() - rt.freeMemory()) > (double)rt.maxMemory() * 0.45) {
                    Grabber.logger.log(Level.WARNING, "Server is at low memory: cleaning memory didn''t help - {0}mb free memory left. Dumping data to the file...", mem);
                    this.dumpAndResetData();
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDumping() {
        Object object = STOP_THE_WORLD_LOCK;
        synchronized (object) {
            return this.dumping;
        }
    }

    private synchronized void dumpAndResetData() throws Exception {
        this.dumping = true;
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = STOP_THE_WORLD_LOCK;
                synchronized (object) {
                    try {
                        Server.this.dataRoot.update();
                        FileSaver fs = FileSaver.getFileSaver(Server.this.dataRoot, Server.this.fileName + Server.this.dumpCount, Server.this.templateName, InstrumentationOptions.MERGE.OVERWRITE, false, true);
                        fs.saveResults(Server.this.fileName + Server.this.dumpCount);
                        if (Server.this.outTestList != null) {
                            Utils.writeLines(Server.this.outTestList + Server.this.dumpCount, Server.this.tests.toArray(new String[Server.this.tests.size()]));
                            Server.this.tests.clear();
                        }
                        Server.this.dataRoot.cleanScales();
                        for (int i = 0; i < Server.this.data.length; ++i) {
                            ((Server)Server.this).data[i] = 0L;
                        }
                        Server.this.dataRoot.update();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                    finally {
                        ++Server.this.dumpCount;
                        Server.this.dumping = false;
                        STOP_THE_WORLD_LOCK.notifyAll();
                    }
                }
            }
        };
        t.setName("DumpingThread" + this.dumpCount);
        t.setPriority(10);
        t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
            }
        });
        t.start();
    }

    private static File getUnexistingFile(File file) {
        String suffix;
        File temp = null;
        do {
            suffix = RuntimeUtils.genSuffix();
        } while ((temp = new File(file.getPath() + suffix)).exists());
        return temp;
    }

    private void waitForAliveClients() {
        for (int timeout = 0; timeout < MAX_TIMEOUT && this.clientsAlive(); timeout += 100) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private boolean clientsAlive() {
        return this.aliveClients > 0;
    }

    public boolean isWorking() {
        return this.working;
    }

    public boolean isStarted() {
        return this.started;
    }

    public int getConnectionsCount() {
        return this.totalConnections;
    }

    public int getAliveConnectionCount() {
        return this.aliveClients;
    }

    public boolean isDataSaved() {
        return this.dataSaved;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public int getPort() {
        if (this.port == 0) {
            if (this.ss != null) {
                return this.ss.getLocalPort();
            }
            if (!this.working) {
                return -1;
            }
        }
        return this.port;
    }

    public boolean isSaveOnReceive() {
        return this.saveAtReceive;
    }

    public int getMaxCount() {
        return this.saveCount;
    }

    public void setMaxCount(int saveCount) {
        this.saveCount = saveCount;
    }

    public static void setMaxTimeout(int MAX_TIMEOUT) {
        Server.MAX_TIMEOUT = MAX_TIMEOUT;
    }

    public void setOutTestList(String outTestList) {
        this.outTestList = outTestList;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getSaveBadData() {
        return this.saveBadData;
    }

    public void setSaveBadData(String saveBadData) {
        this.saveBadData = saveBadData;
    }
}

