/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov;

import com.sun.tdk.jcov.filter.MemberFilter;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataField;
import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.instrument.DataPackage;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.report.ClassCoverage;
import com.sun.tdk.jcov.report.LineCoverage;
import com.sun.tdk.jcov.report.MethodCoverage;
import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JCovCMDTool;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiffCoverage
extends JCovCMDTool {
    private String file;
    private File diffFile;
    private HashMap<String, SourceLine[]> sources;
    private HashMap<Integer, String> sourceLines;
    private static final Logger logger;
    private String replaceDiff;
    private String replaceClass;
    private boolean all;
    static OptionDescr DSC_REPLACE_DIFF;
    static OptionDescr DSC_REPLACE_CLASS;
    static OptionDescr DSC_ALL;

    @Override
    protected int run() throws Exception {
        final LinkedList<String> classNames = new LinkedList<String>();
        try {
            String sourceName;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.diffFile), "UTF-8"));
            HGDiffHandler handler = new HGDiffHandler(in);
            this.sources = new HashMap();
            while ((sourceName = handler.getNextSource()) != null) {
                SourceLine line;
                LinkedList<SourceLine> lines = new LinkedList<SourceLine>();
                while ((line = handler.getNextSourceLine()) != null) {
                    lines.add(line);
                }
                if (lines.size() > 0) {
                    classNames.add(sourceName.substring(sourceName.lastIndexOf(47) + 1));
                    logger.log(Level.INFO, "File {0} has {1} new lines", new Object[]{sourceName, lines.size()});
                    if (this.replaceDiff != null) {
                        String[] split = this.replaceDiff.split(":");
                        String patt = split[0];
                        String with = split.length == 1 ? "" : split[1];
                        sourceName = sourceName.replaceAll(patt, with);
                    }
                    this.sources.put(sourceName, lines.toArray(new SourceLine[lines.size()]));
                    continue;
                }
                logger.log(Level.INFO, "File {0} doesn't have new lines", sourceName);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error while parsing diff file", ex);
            if (ex instanceof NullPointerException) {
                ex.printStackTrace();
            }
            return 2;
        }
        DataRoot data = DataRoot.read(this.file, false, new MemberFilter(){

            @Override
            public boolean accept(DataClass clz) {
                return classNames.contains(clz.getSource());
            }

            @Override
            public boolean accept(DataClass clz, DataMethod m) {
                return true;
            }

            @Override
            public boolean accept(DataClass clz, DataField f) {
                return true;
            }
        });
        int notCovered = 0;
        int covered = 0;
        int nonCode = 0;
        int noInformation = 0;
        for (DataPackage p : data.getPackages()) {
            HashMap classesMap = new HashMap();
            for (DataClass c : p.getClasses()) {
                String className;
                String packageName = c.getPackageName();
                String string = className = !packageName.isEmpty() ? packageName + "/" + c.getSource() : c.getSource();
                if (this.replaceClass != null) {
                    String[] split = this.replaceClass.split(":");
                    String patt = split[0];
                    String with = split.length == 1 ? "" : split[1];
                    className = className.replaceAll(patt, with);
                }
                if (classesMap.get(className) == null) {
                    classesMap.put(className, new ArrayList());
                }
                ((ArrayList)classesMap.get(className)).add(new ClassCoveragePair(c));
            }
            for (String cln : classesMap.keySet()) {
                SourceLine[] lines = this.sources.get(cln);
                if (lines == null) continue;
                ArrayList<DataMethod> methods = new ArrayList<DataMethod>();
                String sourceClassName = "";
                for (int i = 0; i < ((ArrayList)classesMap.get(cln)).size(); ++i) {
                    DataClass dc = ((ClassCoveragePair)((ArrayList)classesMap.get(cln)).get(i)).getDataClass();
                    methods.addAll(dc.getMethods());
                    if (dc.getFullname().contains("$")) continue;
                    sourceClassName = dc.getName();
                }
                for (DataMethod m : methods) {
                    boolean changed = false;
                    LineCoverage lc = new MethodCoverage(m, false).getLineCoverage();
                    for (SourceLine line : lines) {
                        if (line.checked || (long)line.line < lc.firstLine() || (long)line.line > lc.lastLine()) continue;
                        line.checked = true;
                        if (!changed && this.all) {
                            System.out.println(String.format("   %s: %s.%s", cln, sourceClassName, m.getFormattedSignature()));
                            changed = true;
                        }
                        if (this.isLineCovered((ArrayList)classesMap.get(cln), line.line)) {
                            ++covered;
                            if (!this.all) continue;
                            System.out.println(String.format("+ %6d |%s", line.line, line.source));
                            continue;
                        }
                        if (this.isCode((ArrayList)classesMap.get(cln), line.line)) {
                            if (!changed && !this.all) {
                                System.out.println(String.format("   %s> %s: %s", cln, sourceClassName, m.getFormattedSignature()));
                                changed = true;
                            }
                            ++notCovered;
                            System.out.println(String.format("- %6d |%s", line.line, line.source));
                            continue;
                        }
                        ++nonCode;
                        if (!this.all) continue;
                        System.out.println(String.format("  %6d |%s", line.line, line.source));
                    }
                }
                for (SourceLine line : lines) {
                    if (line.checked) continue;
                    line.codeByDefault = false;
                    ++nonCode;
                }
            }
        }
        for (String diffClasses : this.sources.keySet()) {
            for (SourceLine line : this.sources.get(diffClasses)) {
                if (line.checked || !line.codeByDefault) continue;
                ++noInformation;
                if (!this.all) continue;
                System.out.println(String.format("? %6d |%s", line.line, line.source));
            }
        }
        System.out.println(String.format("lines: %d new; %d covered; %d not covered; %d not code; %d no information", nonCode + notCovered + covered + noInformation, covered, notCovered, nonCode, noInformation));
        return 0;
    }

    private boolean isLineCovered(ArrayList<ClassCoveragePair> classes, int line) {
        for (int i = 0; i < classes.size(); ++i) {
            ClassCoverage cc = classes.get(i).getClassCoverage();
            if (!cc.isLineCovered(line)) continue;
            return true;
        }
        return false;
    }

    private boolean isCode(ArrayList<ClassCoveragePair> classes, int line) {
        for (int i = 0; i < classes.size(); ++i) {
            ClassCoverage cc = classes.get(i).getClassCoverage();
            if (!cc.isCode(line)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected EnvHandler defineHandler() {
        return new EnvHandler(new OptionDescr[]{DSC_REPLACE_DIFF, DSC_REPLACE_CLASS, DSC_ALL}, (JCovTool)this);
    }

    @Override
    protected int handleEnv(EnvHandler envHandler) throws JCovTool.EnvHandlingException {
        String[] tail = envHandler.getTail();
        if (tail == null) {
            throw new JCovTool.EnvHandlingException("No input files. Please specify JCov data file and diff (mercurial) file.");
        }
        if (tail.length < 2) {
            throw new JCovTool.EnvHandlingException("Not enough input files. Please specify JCov data file and diff (mercurial) file.");
        }
        this.file = tail[0];
        Utils.checkFileNotNull(tail[0], "JCov datafile", Utils.CheckOptions.FILE_EXISTS, Utils.CheckOptions.FILE_ISFILE, Utils.CheckOptions.FILE_CANREAD);
        this.diffFile = new File(tail[1]);
        Utils.checkFile(this.diffFile, "diff file", Utils.CheckOptions.FILE_EXISTS, Utils.CheckOptions.FILE_ISFILE, Utils.CheckOptions.FILE_CANREAD);
        this.replaceDiff = envHandler.getValue(DSC_REPLACE_DIFF);
        this.replaceClass = envHandler.getValue(DSC_REPLACE_CLASS);
        this.all = envHandler.isSet(DSC_ALL);
        return 0;
    }

    @Override
    protected String getDescr() {
        return "check whether changed lines were covered";
    }

    @Override
    protected String usageString() {
        return "java -jar jcov.jar diffcoverage result.xml diff";
    }

    @Override
    protected String exampleString() {
        return "java -jar jcov.jar diffcoverage -replace src/classes/: result.xml diff";
    }

    static {
        Utils.initLogger();
        logger = Logger.getLogger(DiffCoverage.class.getName());
        DSC_REPLACE_DIFF = new OptionDescr("replaceDiff", "Manage replacing", 1, "Set replacement pattern for diff filenames (e.g. to cut out \"src/classes\" you can specify -replaceDiff src/classes:)");
        DSC_REPLACE_CLASS = new OptionDescr("replaceClass", "", 1, "Set replacement pattern for class filenames (e.g. to cut out \"com/sun\" you can specify -replaceDiff com/sun:)");
        DSC_ALL = new OptionDescr("all", "Manage output", 0, "Show covered and non-code lines as well as not covered");
    }

    static class HGDiffHandler
    implements DiffHandler {
        BufferedReader in;
        String current;
        int startLines = -1;
        int endLines = -1;
        private static String LINES_NUMBERS_PATTERN = "@@ [-+][\\d]+,[\\d]+ [-+][\\d]+,[\\d]+ @@(?s).*";

        public HGDiffHandler(BufferedReader in) {
            this.in = in;
        }

        @Override
        public String getNextSource() throws IOException {
            if (this.current == null || !this.current.startsWith("+++")) {
                this.current = this.in.readLine();
            }
            while (this.current != null && (!this.current.startsWith("+++") || !this.current.contains(".java") || this.current.contains("package-info.java") || this.current.contains("module-info.java"))) {
                this.current = this.in.readLine();
            }
            if (this.current != null) {
                String next = this.in.readLine();
                if (next.startsWith("@@")) {
                    String filepath = this.current.substring(0, this.current.lastIndexOf(".java") + 5);
                    filepath = filepath.replaceAll("\\+\\+\\+ ([a-zA-Z]/)?", "");
                    this.current = next;
                    return filepath;
                }
                this.current = null;
            }
            return null;
        }

        @Override
        public SourceLine getNextSourceLine() throws IOException {
            if (this.current != null && !this.current.startsWith("---")) {
                if (this.startLines == -1 && this.endLines == -1) {
                    String linesNumbersLine = this.current;
                    while (linesNumbersLine == null || !linesNumbersLine.matches(LINES_NUMBERS_PATTERN)) {
                        linesNumbersLine = this.in.readLine();
                        if (linesNumbersLine == null) {
                            this.startLines = -1;
                            this.endLines = -1;
                            this.current = null;
                            return null;
                        }
                        if (!linesNumbersLine.matches("---")) continue;
                        this.startLines = -1;
                        this.endLines = -1;
                        this.current = null;
                        return null;
                    }
                    linesNumbersLine = linesNumbersLine.substring(0, linesNumbersLine.lastIndexOf("@@") + 2);
                    linesNumbersLine = linesNumbersLine.replaceAll(" @@", "");
                    linesNumbersLine = linesNumbersLine.replaceAll("@@ .*\\+", "");
                    String[] split = linesNumbersLine.split(",");
                    this.startLines = Integer.parseInt(split[0]);
                    this.endLines = Integer.parseInt(split[1]) + this.startLines;
                }
            } else if (this.current != null) {
                return null;
            }
            String plusLine = null;
            while (plusLine == null || !plusLine.startsWith("+")) {
                plusLine = this.in.readLine();
                if (plusLine == null) {
                    this.startLines = -1;
                    this.endLines = -1;
                    this.current = null;
                    return null;
                }
                if (!plusLine.startsWith("-")) {
                    ++this.startLines;
                }
                if (plusLine.startsWith("---")) {
                    this.startLines = -1;
                    this.endLines = -1;
                    this.current = plusLine;
                    return null;
                }
                if (!plusLine.matches(LINES_NUMBERS_PATTERN)) continue;
                this.startLines = -1;
                this.endLines = -1;
                this.current = plusLine;
                return this.getNextSourceLine();
            }
            SourceLine line = new SourceLine(this.startLines - 1, plusLine.substring(1));
            if (this.startLines > this.endLines) {
                this.startLines = -1;
                this.endLines = -1;
                this.current = null;
            }
            return line;
        }
    }

    static interface DiffHandler {
        public String getNextSource() throws IOException;

        public SourceLine getNextSourceLine() throws IOException;
    }

    public static class SourceLine {
        public int line;
        public String source;
        boolean checked;
        boolean codeByDefault = true;

        public SourceLine(int line, String source) {
            this.line = line;
            this.source = source;
        }

        public SourceLine() {
        }

        public boolean hits(int start, int end) {
            return this.line > start && this.line < end;
        }

        public String toString() {
            return "[line = " + this.line + ", source = " + this.source + "]";
        }
    }

    private class ClassCoveragePair {
        private DataClass dClass;
        private ClassCoverage cClass;

        public ClassCoveragePair(DataClass dClass) {
            this.dClass = dClass;
            this.cClass = new ClassCoverage(dClass, null, MemberFilter.ACCEPT_ALL);
        }

        public DataClass getDataClass() {
            return this.dClass;
        }

        public ClassCoverage getClassCoverage() {
            return this.cClass;
        }
    }
}

