/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.util.Properties;
import org.testng.TestNGException;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlScript;
import org.testng.xml.XmlSuite;

public class XmlMethodSelector {
    private String m_className;
    private int m_priority;
    private XmlScript m_script;

    public void setClassName(String s) {
        this.m_className = s;
    }

    public String getClassName() {
        return this.m_className;
    }

    public void setElement(String name, String priority) {
        this.setName(name);
        this.setPriority(Integer.parseInt(priority));
    }

    public void setName(String name) {
        this.m_className = name;
    }

    public XmlScript getScript() {
        return this.m_script;
    }

    public void setScript(XmlScript script) {
        this.m_script = script;
    }

    @Deprecated
    public String getExpression() {
        if (this.m_script == null) {
            return null;
        }
        return this.m_script.getExpression();
    }

    @Deprecated
    public void setExpression(String expression) {
        if (this.m_script == null) {
            this.m_script = new XmlScript();
        }
        this.m_script.setExpression(expression);
    }

    @Deprecated
    public String getLanguage() {
        if (this.m_script == null) {
            return null;
        }
        return this.m_script.getLanguage();
    }

    @Deprecated
    public void setLanguage(String language) {
        if (this.m_script == null) {
            this.m_script = new XmlScript();
        }
        this.m_script.setLanguage(language);
    }

    public int getPriority() {
        return this.m_priority;
    }

    public void setPriority(int priority) {
        this.m_priority = priority;
    }

    public String toXml(String indent) {
        XMLStringBuffer xsb = new XMLStringBuffer(indent);
        xsb.push("method-selector");
        if (null != this.m_className) {
            Properties clsProp = new Properties();
            clsProp.setProperty("name", this.getClassName());
            if (this.getPriority() != -1) {
                clsProp.setProperty("priority", String.valueOf(this.getPriority()));
            }
            xsb.addEmptyElement("selector-class", clsProp);
        } else if (this.getScript() != null && this.getScript().getLanguage() != null) {
            Properties scriptProp = new Properties();
            scriptProp.setProperty("language", this.getScript().getLanguage());
            xsb.push("script", scriptProp);
            xsb.addCDATA(this.getScript().getExpression());
            xsb.pop("script");
        } else {
            throw new TestNGException("Invalid Method Selector:  found neither class name nor language");
        }
        xsb.pop("method-selector");
        return xsb.toXML();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_className == null ? 0 : this.m_className.hashCode());
        if (this.getScript() != null) {
            result = 31 * result + (this.getScript().getExpression() == null ? 0 : this.getScript().getExpression().hashCode());
            result = 31 * result + (this.getScript().getLanguage() == null ? 0 : this.getScript().getLanguage().hashCode());
        }
        result = 31 * result + this.m_priority;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return XmlSuite.f();
        }
        if (this.getClass() != obj.getClass()) {
            return XmlSuite.f();
        }
        XmlMethodSelector other = (XmlMethodSelector)obj;
        if (this.m_className == null ? other.m_className != null : !this.m_className.equals(other.m_className)) {
            return XmlSuite.f();
        }
        if (this.getScript() == null || this.getScript().getExpression() == null ? other.getScript() != null && other.getScript().getExpression() != null : !this.getScript().getExpression().equals(other.getScript() == null ? null : other.getScript().getExpression())) {
            return XmlSuite.f();
        }
        if (this.getScript() == null || this.getScript().getLanguage() == null ? other.getScript() != null && other.getScript().getLanguage() != null : !this.getScript().getLanguage().equals(other.getScript() == null ? null : other.getScript().getLanguage())) {
            return XmlSuite.f();
        }
        if (this.m_priority != other.m_priority) {
            return XmlSuite.f();
        }
        return true;
    }
}

