/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import org.testng.IReporter;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.internal.ClassHelper;
import org.testng.internal.InstanceCreator;
import org.testng.internal.Utils;

public class ReporterConfig {
    protected String className;
    protected final List<Property> properties;

    public ReporterConfig(String className, List<Property> properties) {
        this.className = className;
        this.properties = properties;
    }

    public String getClassName() {
        return this.className;
    }

    @Deprecated
    public List<Property> getProperties() {
        return this.properties;
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder(this.className);
        if (!this.properties.isEmpty()) {
            sb.append(":");
            for (int i = 0; i < this.properties.size(); ++i) {
                Property property = this.properties.get(i);
                sb.append(property);
                if (i >= this.properties.size() - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public static ReporterConfig deserialize(String inputString) {
        String className;
        if (Utils.isStringEmpty(inputString)) {
            return null;
        }
        List<Property> properties = Lists.newArrayList();
        int clsNameEndIndex = inputString.indexOf(58);
        if (clsNameEndIndex == -1) {
            className = inputString;
        } else {
            className = inputString.substring(0, clsNameEndIndex);
            String propString = inputString.substring(clsNameEndIndex + 1);
            for (String prop : propString.split(",")) {
                String[] propNameAndVal = prop.split("=");
                if (propNameAndVal.length != 2) continue;
                properties.add(new Property(propNameAndVal[0], propNameAndVal[1]));
            }
        }
        return new ReporterConfig(className, properties);
    }

    public IReporter newReporterInstance() {
        Class<?> reporterClass = ClassHelper.forName(this.className);
        if (reporterClass == null) {
            return null;
        }
        if (!IReporter.class.isAssignableFrom(reporterClass)) {
            throw new TestNGException(this.className + " is not a IReporter");
        }
        IReporter reporter = (IReporter)InstanceCreator.newInstance(reporterClass);
        reporter.getConfig().setProperties(this.properties);
        return reporter;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\nClass = ").append(this.className);
        for (Property prop : this.properties) {
            buf.append("\n\t ").append(prop);
        }
        return buf.toString();
    }

    public static class Property {
        private final String name;
        private final String value;

        public Property(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + "=" + this.value;
        }
    }
}

