/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.collections.CollectionUtils;
import org.testng.collections.Lists;
import org.testng.internal.IMethodRunner;
import org.testng.internal.ITestInvoker;
import org.testng.internal.InvokedMethod;
import org.testng.internal.Parameters;
import org.testng.internal.PoolService;
import org.testng.internal.TestMethodArguments;
import org.testng.internal.TestMethodWithDataProviderMethodWorker;
import org.testng.xml.XmlSuite;

class MethodRunner
implements IMethodRunner {
    MethodRunner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITestResult> runInSequence(TestMethodArguments arguments, ITestInvoker testInvoker, ITestContext context, AtomicInteger invocationCount, ITestInvoker.FailureContext failure, Iterator<Object[]> allParamValues, boolean skipFailedInvocationCounts) {
        List<ITestResult> result = Lists.newArrayList();
        int parametersIndex = 0;
        Iterable<Object[]> allParameterValues = CollectionUtils.asIterable(allParamValues);
        for (Object[] next : allParameterValues) {
            boolean lastSucces;
            TestMethodArguments tmArguments;
            List tmpResults;
            block13: {
                if (next == null) {
                    ++parametersIndex;
                    continue;
                }
                Object[] parameterValues = Parameters.injectParameters(next, arguments.getTestMethod().getConstructorOrMethod().getMethod(), context);
                tmpResults = Lists.newArrayList();
                int tmpResultsIndex = -1;
                tmArguments = new TestMethodArguments.Builder().usingArguments(arguments).withParameterValues(parameterValues).withParametersIndex(parametersIndex).build();
                try {
                    ITestResult tmpResult = testInvoker.invokeTestMethod(tmArguments, context.getSuite().getXmlSuite(), failure);
                    tmpResults.add(tmpResult);
                    lastSucces = false;
                    if (++tmpResultsIndex < 0) break block13;
                    boolean bl = lastSucces = ((ITestResult)tmpResults.get(tmpResultsIndex)).getStatus() == 1;
                }
                catch (Throwable throwable) {
                    boolean lastSucces2 = false;
                    if (tmpResultsIndex >= 0) {
                        boolean bl = lastSucces2 = ((ITestResult)tmpResults.get(tmpResultsIndex)).getStatus() == 1;
                    }
                    if (failure.instances.isEmpty() || lastSucces2) {
                        result.addAll(tmpResults);
                    } else {
                        List<ITestResult> retryResults = Lists.newArrayList();
                        failure = testInvoker.retryFailed(tmArguments, retryResults, failure.count, context);
                        result.addAll(retryResults);
                    }
                    if (failure.count > 0 && (skipFailedInvocationCounts || tmArguments.getTestMethod().skipFailedInvocations())) {
                        while (invocationCount.getAndDecrement() > 0) {
                            ITestResult r = testInvoker.registerSkippedTestResult(tmArguments.getTestMethod(), System.currentTimeMillis(), null);
                            result.add(r);
                            InvokedMethod invokedMethod = new InvokedMethod(r.getInstance(), tmArguments.getTestMethod(), System.currentTimeMillis(), r);
                            testInvoker.invokeListenersForSkippedTestResult(r, invokedMethod);
                        }
                    }
                    throw throwable;
                }
            }
            if (failure.instances.isEmpty() || lastSucces) {
                result.addAll(tmpResults);
            } else {
                List<ITestResult> retryResults = Lists.newArrayList();
                failure = testInvoker.retryFailed(tmArguments, retryResults, failure.count, context);
                result.addAll(retryResults);
            }
            if (failure.count > 0 && (skipFailedInvocationCounts || tmArguments.getTestMethod().skipFailedInvocations())) {
                while (invocationCount.getAndDecrement() > 0) {
                    ITestResult r = testInvoker.registerSkippedTestResult(tmArguments.getTestMethod(), System.currentTimeMillis(), null);
                    result.add(r);
                    InvokedMethod invokedMethod = new InvokedMethod(r.getInstance(), tmArguments.getTestMethod(), System.currentTimeMillis(), r);
                    testInvoker.invokeListenersForSkippedTestResult(r, invokedMethod);
                }
            }
            ++parametersIndex;
        }
        return result;
    }

    @Override
    public List<ITestResult> runInParallel(TestMethodArguments arguments, ITestInvoker testInvoker, ITestContext context, AtomicInteger invocationCount, ITestInvoker.FailureContext failure, Iterator<Object[]> allParamValues, boolean skipFailedInvocationCounts) {
        XmlSuite suite = context.getSuite().getXmlSuite();
        List<ITestResult> result = Lists.newArrayList();
        List workers = Lists.newArrayList();
        int parametersIndex = 0;
        Iterable<Object[]> allParameterValues = CollectionUtils.asIterable(allParamValues);
        for (Object[] next : allParameterValues) {
            if (next == null) {
                ++parametersIndex;
                continue;
            }
            Object[] parameterValues = Parameters.injectParameters(next, arguments.getTestMethod().getConstructorOrMethod().getMethod(), context);
            TestMethodWithDataProviderMethodWorker w = new TestMethodWithDataProviderMethodWorker(testInvoker, arguments.getTestMethod(), parametersIndex, parameterValues, arguments.getInstance(), arguments.getParameters(), arguments.getTestClass(), arguments.getBeforeMethods(), arguments.getAfterMethods(), arguments.getGroupMethods(), context, skipFailedInvocationCounts, invocationCount.get(), failure.count, testInvoker.getNotifier());
            workers.add(w);
            ++parametersIndex;
        }
        PoolService ps = new PoolService(suite.getDataProviderThreadCount());
        List r = ps.submitTasksAndWait(workers);
        for (List l2 : r) {
            result.addAll(l2);
        }
        return result;
    }
}

