/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.testng.IConfigurable;
import org.testng.IConfigureCallBack;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.InvokeMethodRunnable;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.collections.ArrayIterator;
import org.testng.internal.collections.OneToTwoDimArrayIterator;
import org.testng.internal.collections.OneToTwoDimIterator;
import org.testng.internal.collections.Pair;
import org.testng.internal.thread.ThreadExecutionException;
import org.testng.internal.thread.ThreadTimeoutException;
import org.testng.internal.thread.ThreadUtil;
import org.testng.xml.XmlSuite;

public class MethodInvocationHelper {
    protected static Object invokeMethodNoCheckedException(Method thisMethod, Object instance, List<Object> parameters) {
        try {
            return MethodInvocationHelper.invokeMethod(thisMethod, instance, parameters);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected static void invokeMethodConsideringTimeout(ITestNGMethod tm, ConstructorOrMethod method, Object targetInstance, Object[] params, ITestResult testResult) throws Throwable {
        if (MethodHelper.calculateTimeOut(tm) <= 0L) {
            MethodInvocationHelper.invokeMethod(method.getMethod(), targetInstance, params);
        } else {
            MethodInvocationHelper.invokeWithTimeout(tm, targetInstance, params, testResult);
            if (!testResult.isSuccess()) {
                Throwable ex = testResult.getThrowable();
                testResult.setStatus(2);
                testResult.setThrowable(ex.getCause() == null ? ex : ex.getCause());
                throw testResult.getThrowable();
            }
        }
    }

    protected static Object invokeMethod(Method thisMethod, Object instance, List<Object> parameters) throws InvocationTargetException, IllegalAccessException {
        return MethodInvocationHelper.invokeMethod(thisMethod, instance, parameters.toArray(new Object[0]));
    }

    protected static Object invokeMethod(Method thisMethod, Object instance, Object[] parameters) throws InvocationTargetException, IllegalAccessException {
        block10: {
            boolean isStatic;
            Utils.checkInstanceOrStatic(instance, thisMethod);
            if (instance != null && !thisMethod.getDeclaringClass().isAssignableFrom(instance.getClass()) && !(isStatic = Modifier.isStatic(thisMethod.getModifiers()))) {
                Class<?> clazz;
                try {
                    thisMethod = clazz.getMethod(thisMethod.getName(), thisMethod.getParameterTypes());
                }
                catch (Exception e) {
                    boolean found = false;
                    for (clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                        try {
                            thisMethod = clazz.getDeclaredMethod(thisMethod.getName(), thisMethod.getParameterTypes());
                            found = true;
                            break;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    if (found) break block10;
                    if (thisMethod.getDeclaringClass().equals(instance.getClass())) {
                        throw new RuntimeException("Can't invoke method " + thisMethod + ", probably due to classloader mismatch");
                    }
                    throw new RuntimeException("Can't invoke method " + thisMethod + " on this instance of " + instance.getClass() + " due to class mismatch");
                }
            }
        }
        if (!Modifier.isPublic(thisMethod.getModifiers()) || !thisMethod.isAccessible()) {
            try {
                thisMethod.setAccessible(true);
            }
            catch (SecurityException e) {
                throw new TestNGException(thisMethod.getName() + " must be public", e);
            }
        }
        MethodInvocationHelper.cleanInterruptStatus();
        return thisMethod.invoke(instance, parameters);
    }

    protected static Iterator<Object[]> invokeDataProvider(Object instance, Method dataProvider, ITestNGMethod method, ITestContext testContext, Object fedInstance, IAnnotationFinder annotationFinder) {
        List<Object> parameters = MethodInvocationHelper.getParameters(dataProvider, method, testContext, fedInstance, annotationFinder);
        Object result = MethodInvocationHelper.invokeMethodNoCheckedException(dataProvider, instance, parameters);
        if (result == null) {
            throw new TestNGException("Data Provider " + dataProvider + " returned a null value");
        }
        if (result instanceof Object[][]) {
            return new ArrayIterator((Object[][])result);
        }
        if (result instanceof Object[]) {
            return new OneToTwoDimArrayIterator((Object[])result);
        }
        if (result instanceof Iterator) {
            Type returnType = dataProvider.getGenericReturnType();
            if (returnType instanceof ParameterizedType) {
                ParameterizedType contentType = (ParameterizedType)returnType;
                Class type = (Class)contentType.getActualTypeArguments()[0];
                if (type.isArray()) {
                    return (Iterator)result;
                }
                return new OneToTwoDimIterator((Iterator)result);
            }
            return (Iterator)result;
        }
        throw new TestNGException("Data Provider " + dataProvider + " must return either Object[][] or Object[] or Iterator<Object[]> or Iterator<Object>, not " + dataProvider.getReturnType());
    }

    /*
     * WARNING - void declaration
     */
    private static List<Object> getParameters(Method dataProvider, ITestNGMethod method, ITestContext testContext, Object fedInstance, IAnnotationFinder annotationFinder) {
        void var11_13;
        ArrayList<Object> parameters = new ArrayList<Object>();
        ArrayList unresolved = new ArrayList();
        ConstructorOrMethod com = method.getConstructorOrMethod();
        int i = 0;
        Class<?>[] classArray = dataProvider.getParameterTypes();
        int n = classArray.length;
        boolean bl = false;
        while (var11_13 < n) {
            Class<?> cls = classArray[var11_13];
            if (cls.equals(Method.class)) {
                parameters.add(com.getMethod());
            } else if (cls.equals(Constructor.class)) {
                parameters.add(com.getConstructor());
            } else if (cls.equals(ConstructorOrMethod.class)) {
                parameters.add(com);
            } else if (cls.equals(ITestNGMethod.class)) {
                parameters.add(method);
            } else if (cls.equals(ITestContext.class)) {
                parameters.add(testContext);
            } else if (cls.equals(Class.class)) {
                parameters.add(com.getDeclaringClass());
            } else {
                boolean isTestInstance = annotationFinder.hasTestInstance(dataProvider, i);
                if (isTestInstance) {
                    parameters.add(fedInstance);
                } else {
                    unresolved.add(new Pair(i, cls));
                }
            }
            ++i;
            ++var11_13;
        }
        if (!unresolved.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Some DataProvider ").append(dataProvider).append(" parameters unresolved: ");
            for (Pair pair : unresolved) {
                sb.append(" at ").append(pair.first()).append(" type ").append(pair.second()).append("\n");
            }
            throw new TestNGException(sb.toString());
        }
        return parameters;
    }

    protected static void invokeHookable(final Object testInstance, final Object[] parameters, IHookable hookable, final Method thisMethod, ITestResult testResult) throws Throwable {
        final Throwable[] error = new Throwable[1];
        IHookCallBack callback = new IHookCallBack(){

            @Override
            public void runTestMethod(ITestResult tr) {
                try {
                    MethodInvocationHelper.invokeMethod(thisMethod, testInstance, parameters);
                    error[0] = null;
                    tr.setThrowable(null);
                }
                catch (Throwable t) {
                    error[0] = t;
                    tr.setThrowable(t);
                }
            }

            @Override
            public Object[] getParameters() {
                return parameters;
            }
        };
        hookable.run(callback, testResult);
        if (error[0] != null) {
            throw error[0];
        }
    }

    protected static void invokeWithTimeout(ITestNGMethod tm, Object instance, Object[] parameterValues, ITestResult testResult) throws InterruptedException, ThreadExecutionException {
        MethodInvocationHelper.invokeWithTimeout(tm, instance, parameterValues, testResult, null);
    }

    protected static void invokeWithTimeout(ITestNGMethod tm, Object instance, Object[] parameterValues, ITestResult testResult, IHookable hookable) throws InterruptedException, ThreadExecutionException {
        if (ThreadUtil.isTestNGThread() && testResult.getTestContext().getCurrentXmlTest().getParallel() != XmlSuite.ParallelMode.TESTS) {
            MethodInvocationHelper.invokeWithTimeoutWithNoExecutor(tm, instance, parameterValues, testResult, hookable);
        } else {
            MethodInvocationHelper.invokeWithTimeoutWithNewExecutor(tm, instance, parameterValues, testResult, hookable);
        }
    }

    private static void cleanInterruptStatus() {
        if (Thread.currentThread().isInterrupted()) {
            Thread.interrupted();
        }
    }

    private static void invokeWithTimeoutWithNoExecutor(ITestNGMethod tm, Object instance, Object[] parameterValues, ITestResult testResult, IHookable hookable) {
        InvokeMethodRunnable imr = new InvokeMethodRunnable(tm, instance, parameterValues, hookable, testResult);
        long startTime = System.currentTimeMillis();
        long realTimeOut = MethodHelper.calculateTimeOut(tm);
        boolean notTimedout = true;
        try {
            Thread currentThread = Thread.currentThread();
            new Thread(() -> {
                try {
                    TimeUnit.MILLISECONDS.sleep(realTimeOut);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                currentThread.interrupt();
            }).start();
            imr.run();
            boolean bl = notTimedout = System.currentTimeMillis() <= startTime + realTimeOut;
            if (notTimedout) {
                testResult.setStatus(1);
            } else {
                ThreadTimeoutException exception = new ThreadTimeoutException("Method " + tm.getQualifiedName() + "() didn't finish within the time-out " + realTimeOut);
                testResult.setThrowable(exception);
                testResult.setStatus(2);
            }
        }
        catch (Exception ex) {
            if (notTimedout) {
                Throwable e = ex.getCause();
                if (e instanceof InvokeMethodRunnable.TestNGRuntimeException) {
                    e = e.getCause();
                }
                testResult.setThrowable(e);
            } else {
                ThreadTimeoutException exception = new ThreadTimeoutException("Method " + tm.getQualifiedName() + "() didn't finish within the time-out " + realTimeOut);
                testResult.setThrowable(exception);
            }
            testResult.setStatus(2);
        }
    }

    private static void invokeWithTimeoutWithNewExecutor(ITestNGMethod tm, Object instance, Object[] parameterValues, ITestResult testResult, IHookable hookable) throws InterruptedException, ThreadExecutionException {
        ExecutorService exec = ThreadUtil.createExecutor(1, tm.getMethodName());
        InvokeMethodRunnable imr = new InvokeMethodRunnable(tm, instance, parameterValues, hookable, testResult);
        Future<Void> future = exec.submit(imr);
        exec.shutdown();
        long realTimeOut = MethodHelper.calculateTimeOut(tm);
        boolean finished = exec.awaitTermination(realTimeOut, TimeUnit.MILLISECONDS);
        if (!finished) {
            exec.shutdownNow();
            ThreadTimeoutException exception = new ThreadTimeoutException("Method " + tm.getQualifiedName() + "() didn't finish within the time-out " + realTimeOut);
            testResult.setThrowable(exception);
            testResult.setStatus(2);
        } else {
            Utils.log("Invoker " + Thread.currentThread().hashCode(), 3, "Method " + tm.getMethodName() + " completed within the time-out " + tm.getTimeOut());
            try {
                future.get();
            }
            catch (ExecutionException e) {
                throw new ThreadExecutionException(e.getCause());
            }
            testResult.setStatus(1);
        }
    }

    protected static void invokeConfigurable(final Object instance, final Object[] parameters, IConfigurable configurableInstance, final Method thisMethod, ITestResult testResult) throws Throwable {
        final Throwable[] error = new Throwable[1];
        IConfigureCallBack callback = new IConfigureCallBack(){

            @Override
            public void runConfigurationMethod(ITestResult tr) {
                try {
                    MethodInvocationHelper.invokeMethod(thisMethod, instance, parameters);
                    error[0] = null;
                    tr.setThrowable(null);
                }
                catch (Throwable t) {
                    error[0] = t;
                    tr.setThrowable(t);
                }
            }

            @Override
            public Object[] getParameters() {
                return parameters;
            }
        };
        configurableInstance.run(callback, testResult);
        if (error[0] != null) {
            throw error[0];
        }
    }
}

