/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.List;
import org.testng.IClass;
import org.testng.ITest;
import org.testng.ITestClass;
import org.testng.ITestMethodFinder;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.IParameterInfo;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.TestNGMethod;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.log4testng.Logger;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

class TestClass
extends NoOpTestClass
implements ITestClass {
    private IAnnotationFinder annotationFinder = null;
    private ITestMethodFinder testMethodFinder = null;
    private IClass iClass = null;
    private String testName;
    private XmlTest xmlTest;
    private XmlClass xmlClass;
    private String m_errorMsgPrefix;
    private static final Logger LOG = Logger.getLogger(TestClass.class);

    protected TestClass(IClass cls, ITestMethodFinder testMethodFinder, IAnnotationFinder annotationFinder, XmlTest xmlTest, XmlClass xmlClass, String errorMsgPrefix) {
        this.m_errorMsgPrefix = errorMsgPrefix;
        this.init(cls, testMethodFinder, annotationFinder, xmlTest, xmlClass);
    }

    @Override
    public String getTestName() {
        return this.testName;
    }

    @Override
    public XmlTest getXmlTest() {
        return this.xmlTest;
    }

    @Override
    public XmlClass getXmlClass() {
        return this.xmlClass;
    }

    public IAnnotationFinder getAnnotationFinder() {
        return this.annotationFinder;
    }

    private void init(IClass cls, ITestMethodFinder testMethodFinder, IAnnotationFinder annotationFinder, XmlTest xmlTest, XmlClass xmlClass) {
        this.log(3, "Creating TestClass for " + cls);
        this.iClass = cls;
        this.m_testClass = cls.getRealClass();
        this.xmlTest = xmlTest;
        this.xmlClass = xmlClass;
        this.testMethodFinder = testMethodFinder;
        this.annotationFinder = annotationFinder;
        this.initTestClassesAndInstances();
        this.initMethods();
    }

    private void initTestClassesAndInstances() {
        Object[] instances;
        for (Object instance : instances = this.getInstances(true, this.m_errorMsgPrefix)) {
            if (!((instance = IParameterInfo.embeddedInstance(instance)) instanceof ITest)) continue;
            this.testName = ((ITest)instance).getTestName();
            break;
        }
        if (this.testName == null) {
            this.testName = this.iClass.getTestName();
        }
    }

    @Override
    public Object[] getInstances(boolean create) {
        return this.iClass.getInstances(create);
    }

    @Override
    public Object[] getInstances(boolean create, String errorMsgPrefix) {
        return this.iClass.getInstances(create, this.m_errorMsgPrefix);
    }

    @Override
    public long[] getInstanceHashCodes() {
        return this.iClass.getInstanceHashCodes();
    }

    @Override
    public void addInstance(Object instance) {
        this.iClass.addInstance(instance);
    }

    private void initMethods() {
        ITestNGMethod[] methods = this.testMethodFinder.getTestMethods(this.m_testClass, this.xmlTest);
        this.m_testMethods = this.createTestMethods(methods);
        for (Object eachInstance : this.iClass.getInstances(false)) {
            Object instance = IParameterInfo.embeddedInstance(eachInstance);
            this.m_beforeSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods(this.testMethodFinder.getBeforeSuiteMethods(this.m_testClass), this.annotationFinder, true, instance);
            this.m_afterSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods(this.testMethodFinder.getAfterSuiteMethods(this.m_testClass), this.annotationFinder, false, instance);
            this.m_beforeTestConfMethods = ConfigurationMethod.createTestConfigurationMethods(this.testMethodFinder.getBeforeTestConfigurationMethods(this.m_testClass), this.annotationFinder, true, instance);
            this.m_afterTestConfMethods = ConfigurationMethod.createTestConfigurationMethods(this.testMethodFinder.getAfterTestConfigurationMethods(this.m_testClass), this.annotationFinder, false, instance);
            this.m_beforeClassMethods = ConfigurationMethod.createClassConfigurationMethods(this.testMethodFinder.getBeforeClassMethods(this.m_testClass), this.annotationFinder, true, instance);
            this.m_afterClassMethods = ConfigurationMethod.createClassConfigurationMethods(this.testMethodFinder.getAfterClassMethods(this.m_testClass), this.annotationFinder, false, instance);
            this.m_beforeGroupsMethods = ConfigurationMethod.createBeforeConfigurationMethods(this.testMethodFinder.getBeforeGroupsConfigurationMethods(this.m_testClass), this.annotationFinder, true, instance);
            this.m_afterGroupsMethods = ConfigurationMethod.createAfterConfigurationMethods(this.testMethodFinder.getAfterGroupsConfigurationMethods(this.m_testClass), this.annotationFinder, false, instance);
            this.m_beforeTestMethods = ConfigurationMethod.createTestMethodConfigurationMethods(this.testMethodFinder.getBeforeTestMethods(this.m_testClass), this.annotationFinder, true, instance);
            this.m_afterTestMethods = ConfigurationMethod.createTestMethodConfigurationMethods(this.testMethodFinder.getAfterTestMethods(this.m_testClass), this.annotationFinder, false, instance);
        }
    }

    private ITestNGMethod[] createTestMethods(ITestNGMethod[] methods) {
        List vResult = Lists.newArrayList();
        for (ITestNGMethod tm : methods) {
            ConstructorOrMethod m = tm.getConstructorOrMethod();
            if (m.getDeclaringClass().isAssignableFrom(this.m_testClass)) {
                for (Object o : this.iClass.getInstances(false)) {
                    this.log(4, "Adding method " + tm + " on TestClass " + this.m_testClass);
                    vResult.add(new TestNGMethod(m.getMethod(), this.annotationFinder, this.xmlTest, o));
                }
                continue;
            }
            this.log(4, "Rejecting method " + tm + " for TestClass " + this.m_testClass);
        }
        return vResult.toArray(new ITestNGMethod[0]);
    }

    public ITestMethodFinder getTestMethodFinder() {
        return this.testMethodFinder;
    }

    private void log(int level, String s) {
        Utils.log("TestClass", level, s);
    }

    protected void dump() {
        LOG.info("===== Test class\n" + this.m_testClass.getName());
        for (ITestNGMethod m : this.m_beforeClassMethods) {
            LOG.info("  @BeforeClass " + m);
        }
        for (ITestNGMethod m : this.m_beforeTestMethods) {
            LOG.info("  @BeforeMethod " + m);
        }
        for (ITestNGMethod m : this.m_testMethods) {
            LOG.info("    @Test " + m);
        }
        for (ITestNGMethod m : this.m_afterTestMethods) {
            LOG.info("  @AfterMethod " + m);
        }
        for (ITestNGMethod m : this.m_afterClassMethods) {
            LOG.info("  @AfterClass " + m);
        }
        LOG.info("======");
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("name", this.m_testClass).toString();
    }

    public IClass getIClass() {
        return this.iClass;
    }
}

