      SUBROUTINE PAR_DEFNL ( PARAM, NDIM, MAXD, VALUES, ACTD, STATUS )
*+
*  Name:
*     PAR_DEFNx
 
*  Purpose:
*     Sets an array of values as the dynamic default for a parameter.
 
*  Language:
*     Starlink Fortran 77
 
*  Invocation:
*     CALL PAR_DEFNx( PARAM, NDIM, MAXD, VALUES, ACTD, STATUS )
 
*  Description:
*     This routine sets an array of values as the dynamic default for
*     a parameter. The dynamic default may be used as the parameter
*     value by means of appropriate specifications in the interface
*     file.
 
*     If the declared parameter type differs from the type of the
*     array supplied, then conversion is performed.
 
*  Arguments:
*     PARAM = CHARACTER*(*) (Given)
*        The name of the parameter.
*     NDIM = INTEGER (Given)
*        The number of dimensions of the values array.
*     MAXD( NDIM ) = INTEGER (Given)
*        The dimensions of the values' array.
*     VALUES( * ) = ? (Given)
*        The default values, given in Fortran order.
*     ACTD( NDIM ) = INTEGER (Given)
*        The dimensions of the dynamic default object to be created.
*     STATUS = INTEGER (Given and Returned)
*        The global status.
 
*  Notes:
*     -  There is a routine for each of the data types character,
*     double precision, integer, logical, and real: replace "x" in the
*     routine name by C, D, I, L, or R respectively as appropriate.  The
*     VALUES argument must have the corresponding data type.
*     - The current implementation of the underlying parameter system,
*     SUBPAR, creates an n-dimensional HDS object, containing the
*     specified values. The ACTD argument gives the dimensions of
*     the object to be created.  If the dynamic default is used as the
*     suggested value in a prompt, the name of this object, rather than
*     its contents, is offered.
 
*  Algorithm:
*     Call the underlying parameter system primitives.
 
*  Authors:
*     BDK: B D Kelly (REVAD::BDK)
*     AJC: A J Chipperfield (STARLINK)
*     MJC: Malcolm J. Currie (STARLINK)
*     {enter_new_authors_here}
 
*  History:
*     10-DEC-1984 (BDK):
*        Original version.
*     2-JUN-1988 (AJC):
*        Revised prologue
*     9-NOV-1990 (AJC):
*        Revised prologue again
*     1992 March 27 (MJC):
*        Used SST prologues.
*     1992 November 13 (MJC):
*        Commented the code, and renamed the NAMECODE identifier.
*        Re-tidied the prologue.
*     {enter_further_changes_here}
 
*  Bugs:
*     {note_any_bugs_here}
 
*-
 
*  Type Definitions:
      IMPLICIT NONE              ! No implicit typing
 
*  Global Constants:
      INCLUDE 'SAE_PAR'          ! SAE Constants
 
*  Arguments Given:
      CHARACTER * ( * ) PARAM
      INTEGER NDIM
      INTEGER MAXD( * )
      LOGICAL VALUES( * )
      INTEGER ACTD( * )
 
*  Status:
      INTEGER STATUS             ! Global status
 
*  Local Variables:
      INTEGER NAMCOD             ! Parameter code-number
 
*.
 
*  Check the inherited global status.
      IF ( STATUS .NE. SAI__OK ) RETURN
 
*  Find the parameter-system pointer to the internal parameter space
*  associated with the parameter.
      CALL SUBPAR_FINDPAR( PARAM, NAMCOD, STATUS )
 
*  Use the pointer to set the dynamic defaults of the n-dimensional
*  array.
      CALL SUBPAR_DEFNL( NAMCOD, NDIM, MAXD, VALUES, ACTD, STATUS )
 
      END
